/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SconceTile
extends TileEntity
implements ILightable,
ITickableTileEntity {
    public int red = 255;
    public int green = 125;
    public int blue = 255;
    public boolean lit;

    public SconceTile() {
        super(BlockRegistry.SCONCE_TILE);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.red = nbt.func_74762_e("red");
        this.red = this.red > 0 ? this.red : 255;
        this.green = nbt.func_74762_e("green");
        this.green = this.green > 0 ? this.green : 125;
        this.blue = nbt.func_74762_e("blue");
        this.blue = this.blue > 0 ? this.blue : 255;
        this.lit = nbt.func_74767_n("lit");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("red", this.red);
        compound.func_74768_a("green", this.green);
        compound.func_74768_a("blue", this.blue);
        compound.func_74757_a("lit", this.lit);
        return super.func_189515_b(compound);
    }

    @Override
    public void onLight(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        this.red = spellContext.colors.r;
        this.green = spellContext.colors.g;
        this.blue = spellContext.colors.b;
        this.lit = true;
        System.out.println("lit");
        if (rayTraceResult instanceof BlockRayTraceResult) {
            BlockState state = world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a());
            world.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - AbstractEffect.getBuffCount(augments, AugmentDampen.class)), 15))), 3);
            world.func_184138_a(((BlockRayTraceResult)rayTraceResult).func_216350_a(), state, (BlockState)state.func_206870_a(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(15)), 3);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K || !this.lit) {
            return;
        }
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        Random rand = world.field_73012_v;
        double xzOffset = 0.15;
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof SconceBlock)) {
            return;
        }
        double centerX = 0.0;
        double centerZ = 0.0;
        if (state.func_177229_b((Property)ScribesBlock.FACING) == Direction.NORTH) {
            centerX = (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.func_177952_p() + 0.8 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.func_177229_b((Property)ScribesBlock.FACING) == Direction.SOUTH) {
            centerX = (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.func_177952_p() + 0.2 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.func_177229_b((Property)ScribesBlock.FACING) == Direction.EAST) {
            centerX = (double)pos.func_177958_n() + 0.2 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        if (state.func_177229_b((Property)ScribesBlock.FACING) == Direction.WEST) {
            centerX = (double)pos.func_177958_n() + 0.8 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
            centerZ = (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset / 4.0, xzOffset / 4.0);
        }
        ParticleColor color = new ParticleColor(rand.nextInt(this.red), rand.nextInt(this.green), rand.nextInt(this.blue));
        int intensity = 10;
        for (int i = 0; i < intensity; ++i) {
            world.func_195594_a(GlowParticleData.createData(color), centerX, (double)pos.func_177956_o() + 0.8 + ParticleUtil.inRange(-0.0, 0.1), centerZ, 0.0, ParticleUtil.inRange(0.0, 0.03f), 0.0);
        }
    }
}

