/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ManaBlock;
import com.hollingsworth.arsnouveau.common.block.SummoningCrystal;
import com.hollingsworth.arsnouveau.common.entity.EntityWhelp;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SummoningCrystalTile
extends AbstractManaTile
implements IAnimatable {
    ArrayList<UUID> entityList = new ArrayList();
    int numEntities = 0;
    int tier = 1;
    int taskIndex;
    public boolean isOff;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public static final String ENTITY_TAG = "entity";

    public SummoningCrystalTile() {
        super(BlockRegistry.SUMMONING_CRYSTAL_TILE);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    private <E extends TileEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("summoning_crystal", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    @Override
    public int getTransferRate() {
        return 0;
    }

    public void summon(LivingEntity entity) {
        if (!this.field_145850_b.field_72995_K) {
            ++this.numEntities;
            this.entityList.add(entity.func_110124_au());
        }
    }

    public void changeTier(PlayerEntity entity) {
        if (this.tier == 1) {
            this.tier = 2;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.5x5"), Util.field_240973_b_);
        } else if (this.tier == 2) {
            this.tier = 3;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.9x9"), Util.field_240973_b_);
        } else if (this.tier == 3) {
            this.tier = 1;
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.summoning_crystal.adjacent"), Util.field_240973_b_);
        }
    }

    public ItemStack insertItem(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, stack);
    }

    public ItemStack getItem(Item item) {
        return BlockUtil.getItemAdjacent(this.field_145850_b, this.field_174879_c, stack -> stack.func_77973_b() == item);
    }

    @Nullable
    public BlockPos getNextTaskLoc(@Nullable List<AbstractSpellPart> recipe, EntityWhelp caster) {
        SpellResolver resolver;
        Block block;
        if (this.isOff) {
            return null;
        }
        List<BlockPos> posList = this.getTargets();
        if (posList == null || posList.isEmpty()) {
            return null;
        }
        if (this.taskIndex + 1 > posList.size()) {
            this.taskIndex = 0;
        }
        BlockPos taskPos = posList.get(this.taskIndex);
        ++this.taskIndex;
        if (this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_185904_a() != Material.field_151579_a && !BlockUtil.isTreeBlock(this.field_145850_b.func_180495_p(taskPos).func_177230_c())) {
            for (int i = 1; i < 4; ++i) {
                if (this.field_145850_b.func_180495_p(taskPos.func_177981_b(i)).func_185904_a() == Material.field_151579_a && !BlockUtil.isTreeBlock(this.field_145850_b.func_180495_p(taskPos.func_177984_a()).func_177230_c())) continue;
                taskPos = taskPos.func_177981_b(i);
                break;
            }
        }
        if ((block = this.field_145850_b.func_180495_p(taskPos).func_177230_c()) instanceof SummoningCrystal || block instanceof ContainerBlock || block instanceof ManaBlock || block instanceof IInventory) {
            return null;
        }
        if (recipe != null && ((Boolean)caster.func_184212_Q().func_187225_a(EntityWhelp.STRICT_MODE)).booleanValue() && !(resolver = new SpellResolver(recipe, new SpellContext(recipe, (LivingEntity)caster))).wouldCastOnBlockSuccessfully(new BlockRayTraceResult(new Vector3d((double)taskPos.func_177958_n(), (double)taskPos.func_177956_o(), (double)taskPos.func_177952_p()), Direction.UP, taskPos, false), (LivingEntity)caster)) {
            return null;
        }
        return taskPos;
    }

    public boolean enoughMana(List<AbstractSpellPart> spellParts) {
        if (spellParts == null) {
            return false;
        }
        return this.enoughMana(new Spell(spellParts).getCastingCost() / 4);
    }

    public boolean enoughMana(int manaCost) {
        return ManaUtil.hasManaNearby(this.field_174879_c, this.field_145850_b, 7, manaCost);
    }

    public boolean removeManaAround(int manaCost) {
        return ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 7, manaCost) != null;
    }

    public boolean removeManaAround(List<AbstractSpellPart> spellParts) {
        return this.removeManaAround(new Spell(spellParts).getCastingCost() / 4);
    }

    public List<BlockPos> getTargets() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (this.tier == 1) {
            positions.add(this.func_174877_v().func_177978_c().func_177977_b());
            positions.add(this.func_174877_v().func_177968_d().func_177977_b());
            positions.add(this.func_174877_v().func_177974_f().func_177977_b());
            positions.add(this.func_174877_v().func_177976_e().func_177977_b());
        }
        if (this.tier == 2) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(2).func_177965_g(2).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(2).func_177985_f(2).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        if (this.tier == 3) {
            BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177964_d(4).func_177965_g(4).func_177979_c(1), (BlockPos)this.func_174877_v().func_177970_e(4).func_177985_f(4).func_177977_b()).forEach(t -> positions.add(new BlockPos((Vector3i)t)));
        }
        return positions;
    }

    public void cleanupKobolds() {
        List list = this.field_145850_b.func_217357_a(EntityWhelp.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(10.0)).stream().map(f -> f.func_110124_au()).collect(Collectors.toList());
        ArrayList<UUID> removed = new ArrayList<UUID>();
        for (UUID uuid : this.entityList) {
            if (list.contains(uuid)) continue;
            removed.add(uuid);
        }
        for (UUID uuid : removed) {
            this.entityList.remove(uuid);
            --this.numEntities;
        }
    }

    public void func_73660_a() {
        Random rand = this.field_145850_b.func_201674_k();
        if (this.field_145850_b.field_72995_K && rand.nextInt(6) == 0) {
            for (int i = 0; i < 10; ++i) {
                this.field_145850_b.func_195594_a(ParticleSparkleData.createData(ParticleUtil.defaultParticleColor(), 0.05f, 60), (double)this.field_174879_c.func_177958_n() + ParticleUtil.inRange(-0.5, 0.5) + 0.5, (double)this.field_174879_c.func_177956_o() + ParticleUtil.inRange(-1.0, 1.0), (double)this.field_174879_c.func_177952_p() + ParticleUtil.inRange(-0.5, 0.5) + 0.5, ParticleUtil.inRange(-0.03, 0.03), ParticleUtil.inRange(0.01, 0.5), ParticleUtil.inRange(-0.03, 0.03));
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L || this.field_145850_b.field_72995_K) {
            return;
        }
        this.cleanupKobolds();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.numEntities = tag.func_74762_e("entities");
        int count = 0;
        while (tag.func_186855_b(ENTITY_TAG + count)) {
            this.entityList.add(tag.func_186857_a(ENTITY_TAG + count));
            ++count;
        }
        this.taskIndex = tag.func_74762_e("task_index");
        this.tier = tag.func_74762_e("tier");
        this.isOff = tag.func_74767_n("is_off");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("entities", this.numEntities);
        for (int i = 0; i < this.entityList.size(); ++i) {
            tag.func_186854_a(ENTITY_TAG + i, this.entityList.get(i));
        }
        tag.func_74768_a("task_index", this.taskIndex);
        tag.func_74768_a("tier", this.tier);
        tag.func_74757_a("is_off", this.isOff);
        return super.func_189515_b(tag);
    }
}

