/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.mana.IManaTile;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VolcanicTile
extends AbstractManaTile
implements IAnimatable {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    int progress;

    public VolcanicTile() {
        super(BlockRegistry.VOLCANIC_TILE);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "hover_controller", 0.0f, this::hover));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "gem_controller", 0.0f, this::gem));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    public void func_73660_a() {
        BlockPos jarPos;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.canAcceptMana()) {
            int numSource = (int)BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177977_b().func_177982_a(1, 0, 1), (BlockPos)this.func_174877_v().func_177977_b().func_177982_a(-1, 0, -1)).filter(b -> this.field_145850_b.func_204610_c(b).func_206886_c() instanceof LavaFluid).map(b -> this.field_145850_b.func_204610_c(b)).filter(FluidState::func_206889_d).count();
            for (ItemEntity i : this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0))) {
                if (i.func_92059_d().func_77973_b() != BlockRegistry.BLAZING_LOG.func_199767_j()) continue;
                int mana = 100;
                this.addMana(mana);
                this.progress += 5;
                i.func_92059_d().func_190918_g(1);
                Networking.sendToNearby(this.field_145850_b, this.func_174877_v(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, i.func_233580_cy_(), new ParticleColor.IntWrapper(255, 0, 0), new int[0]));
                break;
            }
            if (numSource > 0) {
                this.addMana(numSource * 2);
                this.progress += 1 + numSource / 2;
            }
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L && this.getCurrentMana() > 0 && (jarPos = ManaUtil.canGiveManaClosest(this.field_174879_c, this.field_145850_b, 5)) != null) {
            this.transferMana(this, (IManaTile)this.field_145850_b.func_175625_s(jarPos));
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, this.field_174879_c, jarPos);
        }
    }

    public void doRandomAction() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AtomicBoolean set = new AtomicBoolean(false);
        BlockPos.func_239588_b_((BlockPos)this.field_174879_c, (int)1, (int)0, (int)1).forEach(p -> {
            if (!set.get() && this.field_145850_b.func_180495_p(p).func_196958_f()) {
                this.field_145850_b.func_175656_a(p, BlockRegistry.LAVA_LILY.getState(this.field_145850_b, (BlockPos)p));
                set.set(true);
            }
        });
        BlockPos magmaPos = this.getBlockInArea(Blocks.field_196814_hQ, 1);
        if (magmaPos != null && this.progress >= 500) {
            this.field_145850_b.func_175656_a(magmaPos, Blocks.field_150353_l.func_176223_P());
            this.progress -= 500;
            return;
        }
        BlockPos stonePos = this.getBlockInArea(Blocks.field_150348_b, 1);
        if (stonePos != null && this.progress >= 300) {
            this.field_145850_b.func_175656_a(stonePos, Blocks.field_196814_hQ.func_176223_P());
            this.progress -= 300;
            return;
        }
        magmaPos = this.getBlockInArea(Blocks.field_196814_hQ, 1);
        if (magmaPos != null && this.progress >= 500) {
            this.field_145850_b.func_175656_a(magmaPos, Blocks.field_150353_l.func_176223_P());
            this.progress -= 500;
            return;
        }
        stonePos = this.getTagInArea((ITag<Block>)Tags.Blocks.STONE, 1);
        if (stonePos != null && this.progress >= 300) {
            this.field_145850_b.func_175656_a(stonePos, Blocks.field_196814_hQ.func_176223_P());
            this.progress -= 300;
            return;
        }
    }

    public BlockPos getTagInArea(ITag<Block> block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(range, -1, range), (BlockPos)this.field_174879_c.func_177982_a(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (posFound.get() == null && this.field_145850_b.func_180495_p(blockPos).func_177230_c().func_203417_a(block)) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(range, -1, range), (BlockPos)this.field_174879_c.func_177982_a(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (posFound.get() == null && this.field_145850_b.func_180495_p(blockPos).func_177230_c() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("progress");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    private <E extends TileEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("core_rotation", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends TileEntity> PlayState hover(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("gem_hover", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends TileEntity> PlayState gem(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("gem_rotation", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }
}

