/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.RecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.ShapedHelper;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class WixieCauldronTile
extends TileEntity
implements ITickableTileEntity,
ITooltipProvider {
    public List<BlockPos> inventories;
    public ItemStack craftingItem;
    int tickCounter;
    boolean converted;
    public int entityID;
    public boolean hasMana;
    public boolean isOff;
    public boolean isCraftingPotion;
    public boolean needsPotionStorage;
    RecipeWrapper recipeWrapper;
    public CraftingProgress craftManager = new CraftingProgress();

    public WixieCauldronTile() {
        super(BlockRegistry.WIXIE_CAULDRON_TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.converted) {
            this.convertedEffect();
            return;
        }
        if (!this.hasMana && this.field_145850_b.func_82737_E() % 5L == 0L && ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 6, 50) != null) {
            this.hasMana = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(true)));
        }
        if (!this.hasMana) {
            return;
        }
        if (this.recipeWrapper == null && this.craftingItem != null) {
            this.setRecipes(null, this.craftingItem);
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.updateInventories();
        }
    }

    public boolean hasWixie() {
        return !this.converted || this.field_145850_b.func_73045_a(this.entityID) != null;
    }

    public boolean isCraftingDone() {
        return this.craftManager.isDone();
    }

    public boolean needsPotion() {
        return this.craftManager.isPotionCrafting && !this.craftManager.hasObtainedPotion();
    }

    public Potion getNeededPotion() {
        return this.craftManager.getPotionNeeded();
    }

    public void givePotion() {
        this.craftManager.setHasObtainedPotion(true);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public boolean giveItem(ItemStack stack) {
        boolean res = this.craftManager.giveItem(stack.func_77973_b());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        return res;
    }

    public void attemptFinish() {
        if (this.craftManager.isDone()) {
            if (!this.isCraftingPotion) {
                if (!this.craftManager.outputStack.func_190926_b()) {
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), this.craftManager.outputStack.func_77946_l()));
                    this.hasMana = false;
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false)));
                }
                for (ItemStack i : this.craftManager.remainingItems) {
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), i.func_77946_l()));
                }
                this.craftManager = new CraftingProgress();
                this.setNewCraft();
            } else {
                if (this.craftManager.potionOut == null) {
                    this.setNewCraft();
                    return;
                }
                BlockPos jarPos = this.findPotionStorage(this.craftManager.potionOut);
                if (jarPos == null) {
                    if (!this.needsPotionStorage) {
                        this.needsPotionStorage = true;
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    }
                    return;
                }
                if (this.field_145850_b.func_175625_s(jarPos) instanceof PotionJarTile) {
                    this.needsPotionStorage = false;
                    ((PotionJarTile)this.field_145850_b.func_175625_s(jarPos)).addAmount(this.craftManager.potionOut, 300);
                    int color = ((PotionJarTile)this.field_145850_b.func_175625_s(jarPos)).getColor();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color >> 0 & 0xFF;
                    int a = color >> 24 & 0xFF;
                    EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c, jarPos, r, g, b);
                    this.field_145850_b.func_217376_c((Entity)aoeProjectile);
                    this.hasMana = false;
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false)));
                    this.craftManager = new CraftingProgress();
                    this.setNewCraft();
                }
            }
        }
    }

    public void setNewCraft() {
        if (this.recipeWrapper == null) {
            return;
        }
        Map<Item, Integer> count = this.getInventoryCount();
        if (this.isCraftingPotion && this.recipeWrapper.recipes.size() > 0) {
            RecipeWrapper.SingleRecipe recipe = this.recipeWrapper.canCraftPotionFromInventory(count, this.field_145850_b, this.field_174879_c);
            if (recipe == null) {
                return;
            }
            if (!(recipe.recipe.get(0) instanceof PotionIngredient)) {
                this.isCraftingPotion = false;
                return;
            }
            PotionIngredient potionIngred = (PotionIngredient)recipe.recipe.get(0);
            Ingredient itemIngred = recipe.recipe.get(1);
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>(Arrays.asList(itemIngred.func_193365_a()));
            this.craftManager = new CraftingProgress(PotionUtils.func_185191_c((ItemStack)potionIngred.getStack()), needed, PotionUtils.func_185191_c((ItemStack)recipe.outputStack));
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        } else {
            RecipeWrapper.SingleRecipe recipe = this.recipeWrapper.canCraftFromInventory(count);
            if (recipe != null) {
                this.craftManager = new CraftingProgress(recipe.outputStack.func_77946_l(), recipe.canCraftFromInventory(count), recipe.iRecipe);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public void setRecipes(PlayerEntity playerEntity, ItemStack stack) {
        RecipeWrapper recipes = new RecipeWrapper();
        if (stack.func_77973_b() == Items.field_151068_bn) {
            for (BrewingRecipe r : ArsNouveauAPI.getInstance().getAllPotionRecipes()) {
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)r.getOutput())) continue;
                this.isCraftingPotion = true;
                ArrayList<Ingredient> list = new ArrayList<Ingredient>();
                list.add(new PotionIngredient(r.getInput().func_193365_a()[0]));
                list.add(r.getIngredient());
                recipes.addRecipe(list, r.getOutput(), null);
            }
        } else {
            for (IRecipe r : this.field_145850_b.func_73046_m().func_199529_aN().func_199510_b()) {
                if (r.func_77571_b().func_77973_b() != stack.func_77973_b()) continue;
                if (r instanceof ShapedRecipe) {
                    ShapedHelper helper = new ShapedHelper((ShapedRecipe)r);
                    for (List<Ingredient> iList : helper.getPossibleRecipes()) {
                        recipes.addRecipe(iList, r.func_77571_b(), r);
                    }
                }
                if (!(r instanceof ShapelessRecipe)) continue;
                recipes.addRecipe((List<Ingredient>)r.func_192400_c(), r.func_77571_b(), r);
            }
            if (!recipes.recipes.isEmpty()) {
                this.isCraftingPotion = false;
            }
        }
        if (!recipes.recipes.isEmpty()) {
            this.recipeWrapper = recipes;
            this.craftingItem = stack.func_77946_l();
        }
        if ((recipes.recipes.isEmpty() || this.recipeWrapper == null || this.recipeWrapper.recipes.isEmpty()) && playerEntity != null) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.wixie.no_recipe"));
        } else if (playerEntity != null) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.wixie.recipe_set"));
        }
    }

    public void updateInventories() {
        this.inventories = new ArrayList<BlockPos>();
        for (BlockPos bPos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177964_d(6).func_177965_g(6).func_177979_c(2), (BlockPos)this.field_174879_c.func_177970_e(6).func_177985_f(6).func_177981_b(2))) {
            if (!(this.field_145850_b.func_175625_s(bPos) instanceof IInventory)) continue;
            this.inventories.add(bPos.func_185334_h());
        }
    }

    @Nullable
    public BlockPos findPotionStorage(Potion passedPot) {
        AtomicReference foundPod = new AtomicReference();
        AtomicBoolean foundOptimal = new AtomicBoolean(false);
        BlockPos.func_239588_b_((BlockPos)this.field_174879_c.func_177979_c(2), (int)4, (int)3, (int)4).forEach(bPos -> {
            PotionJarTile tile;
            if (!foundOptimal.get() && this.field_145850_b.func_175625_s(bPos) instanceof PotionJarTile && ((tile = (PotionJarTile)this.field_145850_b.func_175625_s(bPos)).canAcceptNewPotion() || tile.isMixEqual(passedPot)) && tile.getMaxFill() - tile.getCurrentFill() >= 300) {
                if (tile.isMixEqual(passedPot) && tile.getAmount() >= 0) {
                    foundOptimal.set(true);
                    foundPod.set(bPos.func_185334_h());
                }
                if (foundPod.get() == null) {
                    foundPod.set(bPos.func_185334_h());
                }
            }
        });
        return (BlockPos)foundPod.get();
    }

    @Nullable
    public static BlockPos findNeededPotion(Potion passedPot, int amount, World level, BlockPos worldPosition) {
        AtomicReference foundPod = new AtomicReference();
        BlockPos.func_239588_b_((BlockPos)worldPosition.func_177979_c(2), (int)4, (int)3, (int)4).forEach(bPos -> {
            PotionJarTile tile;
            if (foundPod.get() == null && level.func_175625_s(bPos) instanceof PotionJarTile && (tile = (PotionJarTile)level.func_175625_s(bPos)).getCurrentFill() >= amount && tile.isMixEqual(passedPot)) {
                foundPod.set(bPos.func_185334_h());
            }
        });
        return (BlockPos)foundPod.get();
    }

    @Nullable
    public BlockPos findNeededPotion(Potion passedPot, int amount) {
        return WixieCauldronTile.findNeededPotion(passedPot, amount, this.field_145850_b, this.field_174879_c);
    }

    public void spawnFlyingItem(BlockPos from, ItemStack stack) {
        EntityFlyingItem flyingItem = new EntityFlyingItem(this.field_145850_b, from.func_177984_a(), this.field_174879_c);
        flyingItem.func_184212_Q().func_187227_b(EntityFlyingItem.HELD_ITEM, (Object)stack.func_77946_l());
        this.field_145850_b.func_217376_c((Entity)flyingItem);
    }

    public void convertedEffect() {
        ++this.tickCounter;
        if (this.tickCounter >= 120 && !this.field_145850_b.field_72995_K) {
            this.converted = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WixieCauldron.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityWixie wixie = new EntityWixie(this.field_145850_b, true, this.field_174879_c);
            wixie.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.field_145850_b.func_217376_c((Entity)wixie);
            ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, this.field_174879_c.func_177984_a());
            this.entityID = wixie.func_145782_y();
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.field_145850_b.field_72995_K) {
            Random r = this.field_145850_b.field_73012_v;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.field_145850_b, this.field_174879_c.func_177982_a(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.field_174879_c, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.field_145850_b.func_217376_c((Entity)proj1);
        }
    }

    private Map<Item, Integer> getInventoryCount() {
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        HashMap<Item, Integer> itemsAvailable = new HashMap<Item, Integer>();
        if (this.inventories == null) {
            return itemsAvailable;
        }
        for (BlockPos p : this.inventories) {
            if (this.field_145850_b.func_175625_s(p) instanceof IInventory) {
                IInventory inventory = (IInventory)this.field_145850_b.func_175625_s(p);
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (!itemsAvailable.containsKey(stack.func_77973_b())) {
                        itemsAvailable.put(stack.func_77973_b(), stack.func_190916_E());
                        continue;
                    }
                    itemsAvailable.put(stack.func_77973_b(), (Integer)itemsAvailable.get(stack.func_77973_b()) + stack.func_190916_E());
                }
                continue;
            }
            stale.add(p);
        }
        for (BlockPos p : stale) {
            this.inventories.remove(p);
        }
        return itemsAvailable;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("crafting")) {
            this.craftingItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("crafting"));
        }
        this.converted = compound.func_74767_n("converted");
        this.craftManager = CraftingProgress.read(compound);
        this.entityID = compound.func_74762_e("entityid");
        this.hasMana = compound.func_74767_n("hasmana");
        this.isOff = compound.func_74767_n("off");
        this.isCraftingPotion = compound.func_74767_n("isPotion");
        this.needsPotionStorage = compound.func_74767_n("storage");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("converted", this.converted);
        if (this.craftingItem != null) {
            CompoundNBT itemTag = new CompoundNBT();
            this.craftingItem.func_77955_b(itemTag);
            compound.func_218657_a("crafting", (INBT)itemTag);
        }
        if (this.craftManager != null) {
            this.craftManager.write(compound);
        }
        compound.func_74768_a("entityid", this.entityID);
        compound.func_74757_a("hasmana", this.hasMana);
        compound.func_74757_a("off", this.isOff);
        compound.func_74757_a("isPotion", this.isCraftingPotion);
        compound.func_74757_a("storage", this.needsPotionStorage);
        return super.func_189515_b(compound);
    }

    @Override
    public List<String> getTooltip() {
        ItemStack potionStack;
        if (this.craftingItem == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (!this.isCraftingPotion) {
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.crafting").getString() + new TranslationTextComponent(this.craftingItem.func_77977_a()).getString());
        } else if (this.craftManager != null && this.craftManager.isPotionCrafting()) {
            potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)this.craftManager.potionOut);
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.crafting").getString() + potionStack.func_200301_q().getString());
            ArrayList tooltip = new ArrayList();
            PotionUtils.func_185182_a((ItemStack)potionStack, tooltip, (float)1.0f);
            for (ITextComponent i : tooltip) {
                strings.add(i.getString());
            }
        }
        if (!this.hasMana) {
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.need_mana").getString());
        }
        if (this.craftManager != null && !this.craftManager.neededItems.isEmpty()) {
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.needs").getString() + new TranslationTextComponent(this.craftManager.neededItems.get(0).func_77977_a()).getString());
        }
        if (this.craftManager != null && this.craftManager.isPotionCrafting() && !this.craftManager.hasObtainedPotion()) {
            potionStack = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potionStack, (Potion)this.craftManager.getPotionNeeded());
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.needs").getString() + potionStack.func_200301_q().getString());
        }
        if (this.needsPotionStorage) {
            strings.add(new TranslationTextComponent("ars_nouveau.wixie.needs_storage").getString());
        }
        return strings;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public static class CraftingProgress {
        public ItemStack outputStack;
        public List<ItemStack> neededItems;
        public List<ItemStack> remainingItems;
        private Potion potionNeeded;
        public Potion potionOut;
        public boolean isPotionCrafting;
        private boolean hasObtainedPotion;

        public CraftingProgress() {
            this.outputStack = ItemStack.field_190927_a;
            this.neededItems = new ArrayList<ItemStack>();
            this.remainingItems = new ArrayList<ItemStack>();
        }

        public CraftingProgress(Potion potionNeeded, List<ItemStack> itemsNeeded, Potion potionOut) {
            this.setPotionNeeded(potionNeeded);
            this.potionOut = potionOut;
            this.neededItems = itemsNeeded;
            this.remainingItems = itemsNeeded;
            this.isPotionCrafting = true;
            this.setHasObtainedPotion(false);
            this.outputStack = ItemStack.field_190927_a;
        }

        public CraftingProgress(ItemStack outputStack, List<ItemStack> neededItems, IRecipe recipe) {
            CraftingInventory inventory = new CraftingInventory(new Container(null, -1){

                public boolean func_75145_c(PlayerEntity playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int i = 0; i < neededItems.size(); ++i) {
                inventory.func_70299_a(i, neededItems.get(i).func_77946_l());
            }
            this.remainingItems = recipe.func_179532_b((IInventory)inventory);
            this.outputStack = outputStack;
            this.neededItems = neededItems;
        }

        public ItemStack getNextItem() {
            return !this.neededItems.isEmpty() ? this.neededItems.get(0) : ItemStack.field_190927_a;
        }

        public boolean giveItem(Item i) {
            if (this.isDone()) {
                return false;
            }
            ItemStack stackToRemove = ItemStack.field_190927_a;
            for (ItemStack stack : this.neededItems) {
                if (stack.func_77973_b() != i) continue;
                stackToRemove = stack;
                break;
            }
            return this.neededItems.remove(stackToRemove);
        }

        public boolean isDone() {
            return !this.isPotionCrafting ? this.neededItems.isEmpty() : this.hasObtainedPotion() && this.neededItems.isEmpty();
        }

        public boolean isPotionCrafting() {
            return this.isPotionCrafting || this.potionOut != Potions.field_185229_a && this.potionOut != null;
        }

        public void write(CompoundNBT tag) {
            CompoundNBT stack = new CompoundNBT();
            this.outputStack.func_77955_b(stack);
            tag.func_218657_a("output_stack", (INBT)stack);
            NBTUtil.writeItems(tag, "progress", this.neededItems);
            NBTUtil.writeItems(tag, "refund", this.remainingItems);
            CompoundNBT outputTag = new CompoundNBT();
            PotionUtil.addPotionToTag(this.potionOut, outputTag);
            tag.func_218657_a("potionout", (INBT)outputTag);
            CompoundNBT neededTag = new CompoundNBT();
            PotionUtil.addPotionToTag(this.getPotionNeeded(), neededTag);
            tag.func_218657_a("potionNeeded", (INBT)neededTag);
            tag.func_74757_a("gotPotion", this.hasObtainedPotion());
            tag.func_74757_a("isPotionCraft", this.isPotionCrafting);
        }

        public static CraftingProgress read(CompoundNBT tag) {
            CraftingProgress progress = new CraftingProgress();
            progress.outputStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("output_stack"));
            progress.neededItems = NBTUtil.readItems(tag, "progress");
            progress.remainingItems = NBTUtil.readItems(tag, "refund");
            progress.potionOut = PotionUtils.func_185187_c((CompoundNBT)tag.func_74775_l("potionout"));
            progress.setPotionNeeded(PotionUtils.func_185187_c((CompoundNBT)tag.func_74775_l("potionNeeded")));
            progress.setHasObtainedPotion(tag.func_74767_n("gotPotion"));
            progress.isPotionCrafting = tag.func_74767_n("isPotionCraft");
            return progress;
        }

        public Potion getPotionNeeded() {
            return this.potionNeeded;
        }

        public void setPotionNeeded(Potion potionNeeded) {
            this.potionNeeded = potionNeeded;
        }

        public boolean hasObtainedPotion() {
            return this.hasObtainedPotion || this.potionNeeded == Potions.field_185230_b;
        }

        public void setHasObtainedPotion(boolean hasObtainedPotion) {
            this.hasObtainedPotion = hasObtainedPotion;
        }
    }
}

