/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.Recipes;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectAquatic;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHaste;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectShield;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApparatusRecipeProvider
implements IDataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    List<EnchantingApparatusRecipe> recipes = new ArrayList<EnchantingApparatusRecipe>();

    public ApparatusRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addEntries();
        Path output = this.generator.func_200391_b();
        for (IEnchantingRecipe iEnchantingRecipe : this.recipes) {
            if (!(iEnchantingRecipe instanceof EnchantingApparatusRecipe)) continue;
            System.out.println(iEnchantingRecipe);
            Path path = ApparatusRecipeProvider.getRecipePath(output, ((EnchantingApparatusRecipe)iEnchantingRecipe).func_199560_c().func_110623_a());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((EnchantingApparatusRecipe)iEnchantingRecipe).asRecipe(), (Path)path);
            if (iEnchantingRecipe.func_77571_b().func_190926_b()) continue;
            Path path1 = ApparatusRecipeProvider.getApparatusPath(output, (EnchantingApparatusRecipe)iEnchantingRecipe);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((EnchantingApparatusRecipe)iEnchantingRecipe).serialize(), (Path)path1);
                System.out.println(iEnchantingRecipe);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save apparatus {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path getApparatusPath(Path pathIn, EnchantingApparatusRecipe e) {
        System.out.println(e.result.func_77973_b().toString());
        return pathIn.resolve("data/ars_nouveau/apparatus/" + e.result.func_77973_b().getRegistryName().toString().replace("ars_nouveau:", "") + ".json");
    }

    public ApparatusRecipeBuilder builder() {
        return ApparatusRecipeBuilder.builder();
    }

    public void addEntries() {
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.beltOfLevitation).withReagent((IItemProvider)ItemsRegistry.mundaneBelt).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem(3, (IItemProvider)Items.field_151008_G).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("launch")).withCategory(ArsNouveauAPI.PatchouliCategories.equipment).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.jarOfLight).withReagent((IItemProvider)Items.field_151069_bo).withPedestalItem(4, (IItemProvider)Items.field_221695_cJ).withPedestalItem(2, (IItemProvider)Items.field_221729_dA).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.GLASS)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)BlockRegistry.MANA_BLOOM_CROP).withReagent(Ingredient.func_199805_a((ITag)Tags.Items.SEEDS)).withPedestalItem(4, Recipes.MANA_GEM).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.ringOfLesserDiscount).withReagent((IItemProvider)ItemsRegistry.ringOfPotential).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS)).withPedestalItem(2, Recipes.MANA_GEM).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.ringOfGreaterDiscount).withReagent((IItemProvider)ItemsRegistry.ringOfLesserDiscount).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).withPedestalItem(2, Recipes.MANA_GEM).build());
        this.addRecipe(new EnchantingApparatusRecipe(new ItemStack((IItemProvider)ItemsRegistry.beltOfUnstableGifts), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.mundaneBelt}), Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT}), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_NETHER_WART), Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE), Ingredient.func_199805_a((ITag)Tags.Items.DUSTS_GLOWSTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq}), Ingredient.func_199805_a((ITag)Tags.Items.DUSTS_REDSTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222088_mr}), Ingredient.func_199805_a((ITag)Tags.Items.FEATHERS)), ArsNouveauAPI.PatchouliCategories.equipment.name()));
        this.addRecipe(this.builder().withResult((IItemProvider)BlockRegistry.SUMMONING_CRYSTAL).withReagent(Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem(4, (IItemProvider)BlockRegistry.ARCANE_STONE).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.whelpCharm).withReagent((IItemProvider)Items.field_151110_aK).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem(3, Recipes.MANA_GEM).withPedestalItem((IItemProvider)ItemsRegistry.noviceSpellBook).build());
        this.addRecipe(this.builder().withResult((IItemProvider)BlockRegistry.ARCANE_RELAY).withReagent((IItemProvider)BlockRegistry.MANA_JAR).withPedestalItem(6, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem(2, Recipes.MANA_GEM).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.carbuncleCharm).withReagent((IItemProvider)ItemsRegistry.carbuncleShard).withPedestalItem(5, Ingredient.func_199805_a((ITag)Tags.Items.NUGGETS_GOLD)).withPedestalItem(3, Recipes.MANA_GEM).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.amuletOfManaBoost).withReagent((IItemProvider)ItemsRegistry.dullTrinket).withPedestalItem(3, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(5, Recipes.MANA_GEM).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.amuletOfManaRegen).withReagent((IItemProvider)ItemsRegistry.dullTrinket).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem(4, Recipes.MANA_GEM).build());
        this.addRecipe(this.builder().withResult((IItemProvider)BlockRegistry.ARCANE_RELAY_SPLITTER).withReagent((IItemProvider)BlockRegistry.ARCANE_RELAY).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_QUARTZ)).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.sylphCharm).withReagent((IItemProvider)ItemsRegistry.sylphShard).withPedestalItem(Recipes.MANA_GEM).withPedestalItem((IItemProvider)BlockRegistry.MANA_BLOOM_CROP).withPedestalItem((IItemProvider)ItemsRegistry.manaBloom).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem((IItemProvider)Items.field_221592_t).withPedestalItem((IItemProvider)Items.field_221593_u).withPedestalItem((IItemProvider)Items.field_221594_v).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.SEEDS_WHEAT)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)BlockRegistry.SPELL_TURRET).withReagent((IItemProvider)Items.field_221656_ap).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("redstone_signal")).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(Recipes.MANA_GEM_BLOCK).withPedestalItem(3, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.VOID_JAR).withReagent((IItemProvider)Items.field_151069_bo).withPedestalItem((IItemProvider)Items.field_151129_at).withPedestalItem((IItemProvider)Items.field_151133_ar).withPedestalItem((IItemProvider)ItemsRegistry.ALLOW_ITEM_SCROLL).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.DOMINION_ROD).withReagent((IItemProvider)Items.field_151055_y).withPedestalItem(2, Recipes.MANA_GEM).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.WIXIE_CHARM).withReagent((IItemProvider)ItemsRegistry.WIXIE_SHARD).withPedestalItem(Ingredient.func_199805_a((ITag)ItemTags.field_200037_g)).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD)).withPedestalItem((IItemProvider)Items.field_221734_cc).withPedestalItem((IItemProvider)Items.field_222088_mr).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.WAND).withReagent(Recipes.ARCHWOOD_LOG).withPedestalItem(4, Recipes.MANA_GEM).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_GOLD)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentAccelerate.INSTANCE)).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.SPELL_BOW).withReagent((IItemProvider)Items.field_151031_f).withPedestalItem(Recipes.MANA_GEM_BLOCK).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.AMPLIFY_ARROW, 32)).withReagent(Ingredient.func_199805_a((ITag)ItemTags.field_219776_M)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.SPLIT_ARROW, 32)).withReagent(Ingredient.func_199805_a((ITag)ItemTags.field_219776_M)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentSplit.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.PIERCE_ARROW, 32)).withReagent(Ingredient.func_199805_a((ITag)ItemTags.field_219776_M)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.POTION_FLASK)).withReagent(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo})).withPedestalItem(2, (IItemProvider)ItemsRegistry.blazeFiber).withPedestalItem(Recipes.MANA_GEM_BLOCK).withPedestalItem(Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.POTION_FLASK_EXTEND_TIME)).withReagent(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.POTION_FLASK})).withPedestalItem(8, (IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)ItemsRegistry.POTION_FLASK_AMPLIFY)).withReagent(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.POTION_FLASK})).withPedestalItem(8, (IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)).build());
        this.addRecipe(this.builder().withResult(new ItemStack((IItemProvider)BlockRegistry.POTION_MELDER)).withReagent(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BlockRegistry.POTION_JAR})).withPedestalItem(2, (IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtract.INSTANCE)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).build());
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199805_a((ITag)ItemTags.field_206964_G)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185299_g, 1, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentAOE.INSTANCE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentDampen.INSTANCE)).buildEnchantmentRecipe(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, (IItemProvider)ItemsRegistry.mythicalClay).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtract.INSTANCE)).withPedestalItem((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)).buildEnchantmentRecipe(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180312_n, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180312_n, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180312_n, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180312_n, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180312_n, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_IRON)).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(0, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185297_d, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_IRON)).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185297_d, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.field_185297_d, 3, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).buildEnchantmentRecipe(Enchantments.field_185297_d, 4, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185300_i, 1, 3000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179562_cC})).buildEnchantmentRecipe(Enchantments.field_185300_i, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(3, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_205158_fa})).buildEnchantmentRecipe(Enchantments.field_185300_i, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151035_b})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185305_q, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151005_D})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185305_q, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151005_D})).withPedestalItem(3, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.field_185305_q, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151046_w})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151037_a})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN)).buildEnchantmentRecipe(Enchantments.field_185305_q, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151046_w})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151047_v})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185305_q, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectSlowfall.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180309_e, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectSlowfall.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180309_e, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectSlowfall.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.SLIMEBALLS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180309_e, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectSlowfall.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180309_e, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_77334_n, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_77334_n, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_77329_d, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_77329_d, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(3, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.field_77329_d, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.field_77329_d, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.field_77329_d, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE)).buildEnchantmentRecipe(Enchantments.field_185311_w, 1, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(6, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185308_t, 1, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185308_t, 2, 8000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185308_t, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(7, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).buildEnchantmentRecipe(Enchantments.field_185312_x, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectKnockback.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180313_o, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectKnockback.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180313_o, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD)).withPedestalItem(6, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185304_p, 1, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(4, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185304_p, 2, 8000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentFortune.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_EMERALD)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185304_p, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentSplit.INSTANCE)})).withPedestalItem(5, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_222192_G, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_222194_I, 1, 2500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_222194_I, 2, 5000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_222194_I, 3, 7500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentPierce.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_222194_I, 4, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185309_u, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185309_u, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185309_u, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185309_u, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(5, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185309_u, 5, 9000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180308_g, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180308_g, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(3, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180308_g, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180308_g, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180308_g, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_180310_c, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180310_c, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(3, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180310_c, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_180310_c, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodTouch.INSTANCE)})).withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_DIAMOND)).buildEnchantmentRecipe(Enchantments.field_180310_c, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectKnockback.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185310_v, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectKnockback.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185310_v, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectHaste.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_222193_H, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectHaste.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_222193_H, 2, 4000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(MethodProjectile.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectHaste.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_222193_H, 3, 6000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185298_f, 1, 3000));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(4, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185298_f, 2, 6000));
        this.addRecipe(this.builder().withPedestalItem(6, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectAquatic.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(Enchantments.field_185298_f, 3, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185302_k, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185302_k, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185302_k, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185302_k, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_QUARTZ)).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185302_k, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtract.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185306_r, 1, 9000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221964_gn})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185303_l, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221964_gn})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185303_l, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221964_gn})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185303_l, 3, 500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221964_gn})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185303_l, 4, 6500));
        this.addRecipe(this.builder().withPedestalItem(4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221964_gn})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185303_l, 5, 8000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAOE.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_191530_r, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAOE.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_191530_r, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAOE.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(3, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_191530_r, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_92091_k, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_92091_k, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ItemsRegistry.WILDEN_SPIKE})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(3, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_92091_k, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(1, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185307_s, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185307_s, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(EffectShield.INSTANCE)})).withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(Enchantments.field_185307_s, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(1, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(4, Recipes.MANA_GEM_BLOCK).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(1, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(4, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(1, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)})).withPedestalItem(4, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, 3, 5000));
        this.addRecipe(this.builder().withPedestalItem(2, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 1, 2000));
        this.addRecipe(this.builder().withPedestalItem(2, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 2, 3500));
        this.addRecipe(this.builder().withPedestalItem(2, (IItemProvider)BlockRegistry.MANA_BERRY_BUSH).withPedestalItem(3, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ArsNouveauAPI.getInstance().getGlyphItem(AugmentExtendTime.INSTANCE)})).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).withPedestalItem(1, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).buildEnchantmentRecipe(EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, 3, 5000));
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.ENCHANTERS_SWORD).withReagent((IItemProvider)Items.field_151048_u).withPedestalItem(1, (IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem(AugmentAmplify.INSTANCE)).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).build());
        this.addRecipe(this.builder().withResult((IItemProvider)ItemsRegistry.ENCHANTERS_SHIELD).withReagent((IItemProvider)Items.field_185159_cQ).withPedestalItem(2, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).withPedestalItem(2, Recipes.MANA_GEM_BLOCK).build());
    }

    public static List<Ingredient> listOfIngred(Item[] items) {
        return Arrays.stream(items).map(xva$0 -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{xva$0})).collect(Collectors.toList());
    }

    public void addRecipe(EnchantingApparatusRecipe recipe) {
        this.recipes.add(recipe);
    }

    private static Path getRecipePath(Path pathIn, Item item) {
        return ApparatusRecipeProvider.getRecipePath(pathIn, item.getRegistryName().func_110623_a());
    }

    private static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipes/" + str + ".json");
    }

    public String func_200397_b() {
        return "Apparatus";
    }
}

