/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class DefaultTableProvider
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockLootTable::new, (Object)LootParameterSets.field_216267_h));

    public DefaultTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    public static class BlockLootTable
    extends BlockLootTables {
        public List<Block> list = new ArrayList<Block>();

        protected void addTables() {
            this.registerDropSelf(BlockRegistry.AB_ALTERNATE);
            this.registerDropSelf(BlockRegistry.ARCANE_BRICKS);
            this.registerDropSelf(BlockRegistry.ARCANE_PEDESTAL);
            this.registerDropSelf(BlockRegistry.ARCANE_STONE);
            this.registerDropSelf(BlockRegistry.AB_BASKET);
            this.registerDropSelf(BlockRegistry.AB_HERRING);
            this.registerDropSelf(BlockRegistry.AB_MOSAIC);
            this.registerDropSelf(BlockRegistry.WARD_BLOCK);
            this.registerDropSelf(BlockRegistry.SPELL_TURRET);
            this.registerDrop((Block)BlockRegistry.ARCANE_ORE, (IItemProvider)ItemsRegistry.manaGem);
            this.registerDropSelf(BlockRegistry.AB_CLOVER);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_SLAB);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_LOG);
            this.registerDropSelf((Block)BlockRegistry.VEXING_LOG);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_LOG);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_LOG);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_SAPLING);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PLANK);
            this.registerDrop(BlockRegistry.WIXIE_CAULDRON, (IItemProvider)Items.field_222089_ms);
            this.registerLeavesAndSticks((Block)BlockRegistry.BLAZING_LEAVES, (Block)BlockRegistry.BLAZING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.CASCADING_LEAVE, (Block)BlockRegistry.CASCADING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.FLOURISHING_LEAVES, (Block)BlockRegistry.FLOURISHING_SAPLING);
            this.registerLeavesAndSticks((Block)BlockRegistry.VEXING_LEAVES, (Block)BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf((Block)BlockRegistry.BLAZING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.VEXING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.CASCADING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.FLOURISHING_WOOD);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_BUTTON);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_STAIRS);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_SLABS);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_FENCE_GATE);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_TRAPDOOR);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_PPlate);
            this.registerDropSelf((Block)BlockRegistry.ARCHWOOD_FENCE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_BLUE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_BLUE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_GREEN);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_GREEN);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_RED);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_RED);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWLOG_PURPLE);
            this.registerDropSelf((Block)BlockRegistry.STRIPPED_AWWOOD_PURPLE);
            this.registerDropDoor((Block)BlockRegistry.ARCHWOOD_DOOR);
            this.registerDropSelf(BlockRegistry.MANA_GEM_BLOCK);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_BASKET);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_CLOVER);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_HERRING);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_MOSAIC);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_ALTERNATING);
            this.registerDropSelf(BlockRegistry.AB_SMOOTH_ASHLAR);
            this.registerDropSelf(BlockRegistry.POTION_MELDER);
            this.registerDropSelf(BlockRegistry.RITUAL_BLOCK);
            this.registerDropSelf(BlockRegistry.SCONCE_BLOCK);
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.func_218522_a(leaves, l_state -> BlockLootTable.func_218540_a((Block)l_state, (Block)sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropDoor(Block block) {
            this.list.add(block);
            this.func_218522_a(block, BlockLootTables::func_239829_a_);
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.func_218492_c(block);
        }

        public void registerDrop(Block input, IItemProvider output) {
            this.list.add(input);
            this.func_218493_a(input, output);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

