/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlyphRecipeProvider
implements IDataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public GlyphRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        List glyphList = ArsNouveauAPI.getInstance().getGlyphMap().values().stream().collect(Collectors.toList());
        Path output = this.generator.func_200391_b();
        for (Glyph g : glyphList) {
            Path path = GlyphRecipeProvider.getGlyphPath(output, g);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)g.asRecipe(), (Path)path);
        }
    }

    private static Path getGlyphPath(Path pathIn, Glyph glyph) {
        return pathIn.resolve("data/ars_nouveau/recipes/glyphs/" + glyph.getRegistryName().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Glyph Recipes";
    }
}

