/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.easing.EasingManager;
import software.bernie.geckolib3.core.easing.EasingType;

public class EntityFlyingItem
extends EntityFollowProjectile {
    public int age;
    int maxAge;
    public static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityFlyingItem.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Float> OFFSET = EntityDataManager.func_187226_a(EntityFlyingItem.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> DIDOFFSET = EntityDataManager.func_187226_a(EntityFlyingItem.class, (IDataSerializer)DataSerializers.field_187198_h);
    boolean wentUp;

    public EntityFlyingItem(World worldIn, Vector3d from, Vector3d to) {
        this(ModEntities.ENTITY_FLYING_ITEM, worldIn);
        this.field_70180_af.func_187227_b(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.field_70180_af.func_187227_b(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.maxAge = (int)Math.floor(from.func_178788_d(to).func_72433_c() * 5.0);
        this.func_70107_b(from.field_72450_a + 0.5, from.field_72448_b, from.field_72449_c + 0.5);
        this.field_70180_af.func_187227_b(RED, (Object)255);
        this.field_70180_af.func_187227_b(GREEN, (Object)25);
        this.field_70180_af.func_187227_b(BLUE, (Object)180);
    }

    public EntityFlyingItem(World worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vector3d((double)from.func_177958_n(), (double)from.func_177956_o(), (double)from.func_177952_p()), new Vector3d((double)to.func_177958_n(), (double)to.func_177956_o(), (double)to.func_177952_p()));
    }

    public EntityFlyingItem(World worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vector3d((double)from.func_177958_n(), (double)from.func_177956_o(), (double)from.func_177952_p()), new Vector3d((double)to.func_177958_n(), (double)to.func_177956_o(), (double)to.func_177952_p()));
        this.field_70180_af.func_187227_b(RED, (Object)r);
        this.field_70180_af.func_187227_b(GREEN, (Object)g);
        this.field_70180_af.func_187227_b(BLUE, (Object)b);
    }

    public EntityFlyingItem(EntityType<EntityFlyingItem> entityAOEProjectileEntityType, World world) {
        super(entityAOEProjectileEntityType, world);
    }

    public static float lerp(double percentCompleted, double startValue, double endValue, EasingType type) {
        if (percentCompleted >= 1.0) {
            return (float)endValue;
        }
        percentCompleted = EasingManager.ease((double)percentCompleted, (EasingType)type, null);
        return (float)EntityFlyingItem.lerpInternal(percentCompleted, startValue, endValue);
    }

    public static double lerpInternal(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public double normalize(double value, double min, double max) {
        return 1.0 - (value - min) / (max - min);
    }

    @Override
    public void func_70071_h_() {
        ++this.age;
        if (this.age > 400) {
            this.func_70106_y();
        }
        Vector3d vec3d2 = this.func_213322_ci();
        BlockPos start = (BlockPos)this.field_70180_af.func_187225_a(from);
        BlockPos end = (BlockPos)this.field_70180_af.func_187225_a(to);
        if (BlockUtil.distanceFrom(this.func_233580_cy_(), end) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom(this.func_233580_cy_(), end) > 14.0) {
            this.func_70106_y();
            if (this.field_70170_p.field_72995_K && ((Boolean)this.field_70180_af.func_187225_a(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientWorld)this.field_70170_p, end);
            }
            return;
        }
        double posX = this.func_226277_ct_();
        double posY = this.func_226278_cu_();
        double posZ = this.func_226281_cx_();
        double time = 1.0 - this.normalize(this.age, 0.0, 80.0);
        EasingType type = EasingType.NONE;
        double startY = start.func_177956_o();
        double endY = (double)end.func_177956_o() + this.getDistanceAdjustment(start, end);
        double lerpX = EntityFlyingItem.lerp(time, (double)start.func_177958_n() + 0.5, (double)end.func_177958_n() + 0.5, type);
        double lerpY = EntityFlyingItem.lerp(time, EntityFlyingItem.lerp(time, startY, endY, type), EntityFlyingItem.lerp(time, endY, startY, type), type);
        double lerpZ = EntityFlyingItem.lerp(time, (double)start.func_177952_p() + 0.5, (double)end.func_177952_p() + 0.5, type);
        BlockPos adjustedPos = new BlockPos(posX, (double)end.func_177956_o(), posZ);
        if (BlockUtil.distanceFrom(adjustedPos, end) <= 0.5) {
            posY = this.func_226278_cu_() - 0.05;
            this.func_70107_b(lerpX, posY, lerpZ);
        } else {
            this.func_70107_b(lerpX, lerpY, lerpZ);
        }
        if (this.field_70170_p.field_72995_K && this.age > 1) {
            double deltaX = this.func_226277_ct_() - this.field_70142_S;
            double deltaY = this.func_226278_cu_() - this.field_70137_T;
            double deltaZ = this.func_226281_cx_() - this.field_70136_U;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.field_70170_p.field_73012_v.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b() == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b()) != 0) continue;
                this.field_70170_p.func_195594_a(GlowParticleData.createData(new ParticleColor((Integer)this.field_70180_af.func_187225_a(RED), (Integer)this.field_70180_af.func_187225_a(GREEN), (Integer)this.field_70180_af.func_187225_a(BLUE))), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
            }
        }
    }

    public EntityFlyingItem withNoTouch() {
        this.field_70180_af.func_187227_b(SPAWN_TOUCH, (Object)false);
        return this;
    }

    public void setDistanceAdjust(float offset) {
        this.field_70180_af.func_187227_b(OFFSET, (Object)Float.valueOf(offset));
        this.field_70180_af.func_187227_b(DIDOFFSET, (Object)true);
    }

    private double getDistanceAdjustment(BlockPos start, BlockPos end) {
        if (((Boolean)this.field_70180_af.func_187225_a(DIDOFFSET)).booleanValue()) {
            return ((Float)this.field_70180_af.func_187225_a(OFFSET)).floatValue();
        }
        double distance = BlockUtil.distanceFrom(start, end);
        if (distance <= 1.5) {
            return 2.5;
        }
        return 3.0;
    }

    public Vector3d getLerped() {
        BlockPos start = (BlockPos)this.field_70180_af.func_187225_a(from);
        BlockPos end = (BlockPos)this.field_70180_af.func_187225_a(to);
        double startY = start.func_177956_o();
        double endY = (double)end.func_177956_o() + 4.0;
        double time = 1.0 - this.normalize(this.age, 0.0, 100.0);
        double yOffset = -3.0;
        EasingType type = EasingType.NONE;
        double lerpX = EntityFlyingItem.lerp(time, (double)start.func_177958_n() + 0.5, (double)end.func_177958_n() + 0.5, type);
        double lerpY = EntityFlyingItem.lerp(time, EntityFlyingItem.lerp(time, startY, endY, type), EntityFlyingItem.lerp(time, endY, startY, type), type);
        double lerpZ = EntityFlyingItem.lerp(time, (double)start.func_177952_p() + 0.5, (double)end.func_177952_p() + 0.5, type);
        return new Vector3d(lerpX, lerpY, lerpZ);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b("item")) {
            this.field_70180_af.func_187227_b(HELD_ITEM, (Object)ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item")));
        }
        this.age = compound.func_74762_e("age");
        this.field_70180_af.func_187227_b(DIDOFFSET, (Object)compound.func_74767_n("didoffset"));
        this.field_70180_af.func_187227_b(OFFSET, (Object)Float.valueOf(compound.func_74760_g("offset")));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getStack() != null) {
            CompoundNBT tag = new CompoundNBT();
            this.getStack().func_77955_b(tag);
            compound.func_218657_a("item", (INBT)tag);
        }
        compound.func_74768_a("age", this.age);
        compound.func_74757_a("didoffset", ((Boolean)this.field_70180_af.func_187225_a(DIDOFFSET)).booleanValue());
        compound.func_74776_a("offset", ((Float)this.field_70180_af.func_187225_a(OFFSET)).floatValue());
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(OFFSET, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DIDOFFSET, (Object)false);
    }

    @Override
    public boolean defaultsBurst() {
        return true;
    }

    @Override
    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_FLYING_ITEM;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityFlyingItem(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntities.ENTITY_FLYING_ITEM, world);
    }
}

