/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFollowProjectile
extends ArrowEntity {
    public static final DataParameter<BlockPos> to = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> from = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<Integer> RED = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> GREEN = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> BLUE = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SPAWN_TOUCH = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> DESPAWN = EntityDataManager.func_187226_a(EntityFollowProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int age;
    int maxAge = 500;

    public EntityFollowProjectile(World world) {
        super(world, 0.0, 0.0, 0.0);
    }

    public void setDespawnDistance(int distance) {
        this.func_184212_Q().func_187227_b(DESPAWN, (Object)distance);
    }

    public EntityFollowProjectile(World worldIn, Vector3d from, Vector3d to) {
        this(ModEntities.ENTITY_FOLLOW_PROJ, worldIn);
        this.field_70180_af.func_187227_b(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.field_70180_af.func_187227_b(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.func_70107_b(from.field_72450_a + 0.5, from.field_72448_b + 0.5, from.field_72449_c + 0.5);
        this.field_70180_af.func_187227_b(RED, (Object)255);
        this.field_70180_af.func_187227_b(GREEN, (Object)25);
        this.field_70180_af.func_187227_b(BLUE, (Object)180);
        double distance = BlockUtil.distanceFrom(new BlockPos(from), new BlockPos(to));
        this.setDespawnDistance((int)(distance + 10.0));
    }

    public EntityFollowProjectile(World worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vector3d((double)from.func_177958_n(), (double)from.func_177956_o(), (double)from.func_177952_p()), new Vector3d((double)to.func_177958_n(), (double)to.func_177956_o(), (double)to.func_177952_p()));
        this.field_70180_af.func_187227_b(RED, (Object)Math.min(r, 255));
        this.field_70180_af.func_187227_b(GREEN, (Object)Math.min(g, 255));
        this.field_70180_af.func_187227_b(BLUE, (Object)Math.min(b, 255));
    }

    public EntityFollowProjectile(World worldIn, BlockPos from, BlockPos to, ParticleColor.IntWrapper color) {
        this(worldIn, from, to, color.r, color.g, color.b);
    }

    public EntityFollowProjectile(World worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vector3d((double)from.func_177958_n(), (double)from.func_177956_o(), (double)from.func_177952_p()), new Vector3d((double)to.func_177958_n(), (double)to.func_177956_o(), (double)to.func_177952_p()));
    }

    public EntityFollowProjectile(EntityType<? extends EntityFollowProjectile> entityAOEProjectileEntityType, World world) {
        super(entityAOEProjectileEntityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(to, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(from, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(RED, (Object)0);
        this.field_70180_af.func_187214_a(GREEN, (Object)0);
        this.field_70180_af.func_187214_a(BLUE, (Object)0);
        this.field_70180_af.func_187214_a(SPAWN_TOUCH, (Object)this.defaultsBurst());
        this.field_70180_af.func_187214_a(DESPAWN, (Object)10);
    }

    public boolean defaultsBurst() {
        return false;
    }

    public void func_70071_h_() {
        ++this.age;
        if (this.age > this.maxAge) {
            this.func_70106_y();
            return;
        }
        Vector3d vec3d2 = this.func_213322_ci();
        BlockPos dest = (BlockPos)this.field_70180_af.func_187225_a(to);
        if (BlockUtil.distanceFrom(this.func_233580_cy_(), dest) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom(this.func_233580_cy_(), dest) > (double)((Integer)this.field_70180_af.func_187225_a(DESPAWN)).intValue()) {
            if (this.field_70170_p.field_72995_K && ((Boolean)this.field_70180_af.func_187225_a(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientWorld)this.field_70170_p, this.func_226268_ag_(), new ParticleColor((Integer)this.field_70180_af.func_187225_a(RED), (Integer)this.field_70180_af.func_187225_a(GREEN), (Integer)this.field_70180_af.func_187225_a(BLUE)));
            }
            this.func_70106_y();
            return;
        }
        double posX = this.func_226277_ct_();
        double posY = this.func_226278_cu_();
        double posZ = this.func_226281_cx_();
        double motionX = this.func_213322_ci().field_72450_a;
        double motionY = this.func_213322_ci().field_72448_b;
        double motionZ = this.func_213322_ci().field_72449_c;
        if (dest.func_177958_n() != 0 || dest.func_177956_o() != 0 || dest.func_177952_p() != 0) {
            double targetX = (double)dest.func_177958_n() + 0.5;
            double targetY = (double)dest.func_177956_o() + 0.5;
            double targetZ = (double)dest.func_177952_p() + 0.5;
            Vector3d targetVector = new Vector3d(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.field_72450_a;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.field_72448_b;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.field_72449_c;
        }
        this.func_70107_b(posX += motionX, posY += motionY, posZ += motionZ);
        this.func_213293_j(motionX, motionY, motionZ);
        if (this.field_70170_p.field_72995_K && this.age > 1) {
            double deltaX = this.func_226277_ct_() - this.field_70142_S;
            double deltaY = this.func_226278_cu_() - this.field_70137_T;
            double deltaZ = this.func_226281_cx_() - this.field_70136_U;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.field_70170_p.field_73012_v.nextInt(2)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b() == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa.func_216832_b()) != 0) continue;
                this.field_70170_p.func_195594_a(GlowParticleData.createData(new ParticleColor((Integer)this.field_70180_af.func_187225_a(RED), (Integer)this.field_70180_af.func_187225_a(GREEN), (Integer)this.field_70180_af.func_187225_a(BLUE))), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(from, (Object)NBTUtil.getBlockPos(compound, "from"));
        this.field_70180_af.func_187227_b(to, (Object)NBTUtil.getBlockPos(compound, "to"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (from != null) {
            NBTUtil.storeBlockPos(compound, "from", (BlockPos)this.field_70180_af.func_187225_a(from));
        }
        if (to != null) {
            NBTUtil.storeBlockPos(compound, "to", (BlockPos)this.field_70180_af.func_187225_a(to));
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityFollowProjectile(FMLPlayMessages.SpawnEntity packet, World world) {
        super(ModEntities.ENTITY_FOLLOW_PROJ, world);
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_FOLLOW_PROJ;
    }

    public boolean func_189652_ae() {
        return true;
    }
}

