/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningCrystalTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.BonemealGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.EvaluateGroveGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.FollowMobGoalBackoff;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.FollowPlayerGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.GenerateDropsGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.InspectPlantGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntitySylph
extends AbstractFlyingCreature
implements IPickupResponder,
IAnimatable,
ITooltipProvider,
IDispellable {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public static ITag.INamedTag<Item> DENIED_DROP = ItemTags.createOptional((ResourceLocation)new ResourceLocation("ars_nouveau", "sylph/denied_drop"));
    public int timeSinceBonemeal = 0;
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntitySylph.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int tamingTime = 0;
    public boolean droppingShards;
    public static final DataParameter<Integer> MOOD_SCORE = EntityDataManager.func_187226_a(EntitySylph.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> COLOR = EntityDataManager.func_187226_a(EntitySylph.class, (IDataSerializer)DataSerializers.field_187194_d);
    public List<ItemStack> ignoreItems;
    public int timeUntilGather = 0;
    public int timeUntilEvaluation = 0;
    public int diversityScore;
    public Map<BlockState, Integer> genTable;
    public Map<BlockState, Integer> scoreMap;
    public BlockPos crystalPos;
    public List<ItemStack> drops;
    private boolean setBehaviors;

    private <E extends Entity> PlayState idlePredicate(AnimationEvent event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idleController", 20.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        List<ItemStack> items;
        if (player.func_130014_f_().field_72995_K) {
            return super.func_230254_b_(player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ItemsRegistry.DENY_ITEM_SCROLL && !(items = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack)).isEmpty()) {
            this.ignoreItems = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack);
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.sylph.ignore"));
        }
        return super.func_230254_b_(player, hand);
    }

    public String getColor() {
        return (String)this.field_70180_af.func_187225_a(COLOR);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (hand != Hand.MAIN_HAND || player.func_130014_f_().field_72995_K || !((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (Tags.Items.DYES.func_230235_a_((Object)item)) {
            System.out.println("contains");
            if (Tags.Items.DYES_GREEN.func_230235_a_((Object)item) && !this.getColor().equals("summer")) {
                this.field_70180_af.func_187227_b(COLOR, (Object)"summer");
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (Tags.Items.DYES_ORANGE.func_230235_a_((Object)item) && !this.getColor().equals("autumn")) {
                this.field_70180_af.func_187227_b(COLOR, (Object)"autumn");
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (Tags.Items.DYES_YELLOW.func_230235_a_((Object)item) && !this.getColor().equals("spring")) {
                this.field_70180_af.func_187227_b(COLOR, (Object)"spring");
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (Tags.Items.DYES_WHITE.func_230235_a_((Object)item) && !this.getColor().equals("winter")) {
                this.field_70180_af.func_187227_b(COLOR, (Object)"winter");
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
        }
        if (stack.func_190926_b()) {
            int moodScore = (Integer)this.field_70180_af.func_187225_a(MOOD_SCORE);
            if (moodScore < 250) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.unhappy"));
            } else if (moodScore <= 500) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.content"));
            } else if (moodScore <= 750) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.happy"));
            } else if (moodScore < 1000) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.very_happy"));
            } else {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.extremely_happy"));
            }
            int numDrops = this.diversityScore / 2;
            if (numDrops <= 5) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.okay_diversity"));
            } else if (numDrops <= 10) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.diverse_enough"));
            } else if (numDrops <= 20) {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.very_diverse"));
            } else {
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.extremely_diverse"));
            }
            if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
                StringBuilder status = new StringBuilder();
                status.append(new TranslationTextComponent("ars_nouveau.sylph.ignore_list").getString());
                for (ItemStack i : this.ignoreItems) {
                    status.append(i.func_200301_q().getString()).append(" ");
                }
                PortUtil.sendMessage((Entity)player, status.toString());
            }
            return ActionResultType.SUCCESS;
        }
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return ActionResultType.PASS;
        }
        BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        int score = EvaluateGroveGoal.getScore(state);
        if (score > 0 && this.scoreMap != null && this.scoreMap.get(state) != null && this.scoreMap.get(state) >= 50) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.toomuch"));
            return ActionResultType.SUCCESS;
        }
        if (score == 0) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.notinterested"));
        }
        if (score == 1) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.likes"));
        }
        if (score == 2) {
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("sylph.excited"));
        }
        return ActionResultType.SUCCESS;
    }

    protected EntitySylph(EntityType<? extends AbstractFlyingCreature> type, World worldIn) {
        super(type, worldIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.addGoalsAfterConstructor();
    }

    public EntitySylph(World world, boolean isTamed, BlockPos pos) {
        super(ModEntities.ENTITY_SYLPH_TYPE, world);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.field_70180_af.func_187227_b(TAMED, (Object)isTamed);
        this.crystalPos = pos;
        this.addGoalsAfterConstructor();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82737_E() % 20L == 0L && this.func_233580_cy_().func_177956_o() < 0) {
                this.func_70106_y();
                return;
            }
            if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(TAMED))) {
                --this.timeUntilEvaluation;
                --this.timeUntilGather;
            }
            ++this.timeSinceBonemeal;
        }
        if (this.droppingShards) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.field_70170_p.func_201670_d()) {
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.func_233580_cy_(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphShard, 1 + this.field_70170_p.field_73012_v.nextInt(1));
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), stack));
                this.remove(false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.func_226277_ct_();
                    double d1 = this.func_226278_cu_() + 0.1;
                    double d2 = this.func_226281_cx_();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    public boolean enoughManaForTask() {
        if (!(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrystalTile)) {
            return false;
        }
        return ((SummoningCrystalTile)this.field_70170_p.func_175625_s(this.crystalPos)).enoughMana(250);
    }

    public boolean removeManaForDrops() {
        if (!(this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrystalTile)) {
            return false;
        }
        return ((SummoningCrystalTile)this.field_70170_p.func_175625_s(this.crystalPos)).removeManaAround(250);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new BonemealGoal(this, () -> this.crystalPos, 10)));
        list.add(new PrioritizedGoal(1, (Goal)new EvaluateGroveGoal(this, 2400)));
        list.add(new PrioritizedGoal(2, (Goal)new InspectPlantGoal((MobEntity)this, () -> this.crystalPos, 15)));
        list.add(new PrioritizedGoal(1, (Goal)new GoBackHomeGoal((MobEntity)this, () -> this.crystalPos, 20)));
        list.add(new PrioritizedGoal(1, (Goal)new GenerateDropsGoal(this)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new FollowMobGoalBackoff((MobEntity)this, 1.0, 3.0f, 7.0f, 0.5f)));
        list.add(new PrioritizedGoal(5, (Goal)new FollowPlayerGoal((MobEntity)this, 1.0, 3.0f, 7.0f)));
        list.add(new PrioritizedGoal(2, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0)));
        list.add(new PrioritizedGoal(1, (Goal)new BonemealGoal(this)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    @SubscribeEvent
    public void treeGrow(SaplingGrowTreeEvent event) {
        if (!((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue() && BlockUtil.distanceFrom(this.func_233580_cy_(), event.getPos()) <= 10.0) {
            this.droppingShards = true;
        }
    }

    protected void func_184651_r() {
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue()) {
            return tooltip;
        }
        int mood = (Integer)this.field_70180_af.func_187225_a(MOOD_SCORE);
        String moodStr = new TranslationTextComponent("ars_nouveau.sylph.tooltip_unhappy").getString();
        if (mood >= 1000) {
            moodStr = new TranslationTextComponent("ars_nouveau.sylph.tooltip_extremely_happy").getString();
        } else if (mood >= 750) {
            moodStr = new TranslationTextComponent("ars_nouveau.sylph.tooltip_very_happy").getString();
        } else if (mood >= 500) {
            moodStr = new TranslationTextComponent("ars_nouveau.sylph.tooltip_happy").getString();
        } else if (mood >= 250) {
            moodStr = new TranslationTextComponent("ars_nouveau.sylph.tooltip_content").getString();
        }
        tooltip.add(new TranslationTextComponent("ars_nouveau.sylph.tooltip_mood").getString() + moodStr);
        return tooltip;
    }

    public boolean isValidReward(ItemStack stack) {
        if (DENIED_DROP.func_230235_a_((Object)stack.func_77973_b())) {
            return false;
        }
        if (this.ignoreItems == null || this.ignoreItems.isEmpty()) {
            return true;
        }
        return this.ignoreItems.stream().noneMatch(i -> i.func_77969_a(stack));
    }

    @Override
    public ItemStack onPickup(ItemStack stack) {
        if (!this.isValidReward(stack)) {
            return stack;
        }
        SummoningCrystalTile tile = this.field_70170_p.func_175625_s(this.crystalPos) instanceof SummoningCrystalTile ? (SummoningCrystalTile)this.field_70170_p.func_175625_s(this.crystalPos) : null;
        return tile == null ? stack : tile.insertItem(stack);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, Attributes.field_233822_e_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.crystalPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
        this.timeSinceBonemeal = tag.func_74762_e("bonemeal");
        this.timeUntilGather = tag.func_74762_e("gather");
        this.timeUntilEvaluation = tag.func_74762_e("eval");
        this.field_70180_af.func_187227_b(TAMED, (Object)tag.func_74767_n("tamed"));
        this.field_70180_af.func_187227_b(MOOD_SCORE, (Object)tag.func_74762_e("score"));
        if (!this.setBehaviors) {
            this.tryResetGoals();
            this.setBehaviors = true;
        }
        this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
        this.field_70180_af.func_187227_b(COLOR, (Object)tag.func_74779_i("color"));
    }

    public void tryResetGoals() {
        this.field_70714_bg.field_220892_d = new LinkedHashSet();
        this.addGoalsAfterConstructor();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.crystalPos != null) {
            tag.func_74768_a("summoner_x", this.crystalPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.crystalPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.crystalPos.func_177952_p());
        }
        tag.func_74768_a("eval", this.timeUntilEvaluation);
        tag.func_74768_a("bonemeal", this.timeSinceBonemeal);
        tag.func_74768_a("gather", this.timeUntilGather);
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
        tag.func_74768_a("score", ((Integer)this.field_70180_af.func_187225_a(MOOD_SCORE)).intValue());
        tag.func_74778_a("color", (String)this.field_70180_af.func_187225_a(COLOR));
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOOD_SCORE, (Object)0);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR, (Object)"summer");
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.sylphCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        }
        return this.isTamed();
    }
}

