/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityWardProjectile
extends EntityProjectileSpell {
    public Entity wardedEntity;
    int ticksLeft;
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityWardProjectile.class, (IDataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> OFFSET = EntityDataManager.func_187226_a(EntityWardProjectile.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityWardProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityWardProjectile(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public EntityWardProjectile(EntityType<EntityWardProjectile> entityWardProjectileEntityType, World world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.field_70180_af.func_187227_b(OFFSET, (Object)offset);
    }

    public int getOffset() {
        return (Integer)this.field_70180_af.func_187225_a(OFFSET) * 15;
    }

    @Override
    public void func_70071_h_() {
        PlayerEntity owner = this.field_70170_p.func_217371_b(this.getOwnerID());
        if (!this.field_70170_p.field_72995_K && owner == null) {
            this.func_70106_y();
            return;
        }
        if (owner == null) {
            return;
        }
        this.func_70107_b(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a(GlowParticleData.createData(ParticleUtil.defaultParticleColor()), (double)((float)this.func_226277_ct_()) - Math.sin((double)(ClientInfo.ticksInGame + this.getOffset()) / 8.0), (double)((float)this.func_226278_cu_() + 1.0f), (double)((float)this.func_226281_cx_()) - Math.cos((double)(ClientInfo.ticksInGame + this.getOffset()) / 8.0), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.of(Util.field_240973_b_));
        this.field_70180_af.func_187214_a(OFFSET, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("left", this.ticksLeft);
        tag.func_74768_a("offset", this.getOffset());
        this.writeOwner(tag);
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.ticksLeft = tag.func_74762_e("left");
        this.setOffset(tag.func_74762_e("offset"));
        if (this.getOwnerID() != null) {
            this.setOwnerID(tag.func_186857_a("owner"));
        }
    }

    @Override
    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_WARD;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityWardProjectile(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType<? extends EntityProjectileSpell>)ModEntities.ENTITY_WARD, world);
    }

    void writeOwner(CompoundNBT tag) {
        if (this.getOwnerID() != null) {
            tag.func_186854_a("owner", this.getOwnerID());
        }
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerID() {
        return !((Optional)this.func_184212_Q().func_187225_a(OWNER_UUID)).isPresent() ? this.func_110124_au() : (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER_UUID)).get();
    }

    public void setOwnerID(UUID uuid) {
        this.func_184212_Q().func_187227_b(OWNER_UUID, Optional.ofNullable(uuid));
    }
}

