/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.AbstractFlyingCreature;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.CompleteCraftingGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindNextItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wixie.FindPotionGoal;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityWixie
extends AbstractFlyingCreature
implements IAnimatable,
IAnimationListener,
IDispellable {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityWixie.class, (IDataSerializer)DataSerializers.field_187198_h);
    public BlockPos cauldronPos;
    public int inventoryBackoff;

    private <P extends IAnimatable> PlayState idlePredicate(AnimationEvent<P> event) {
        if (this.func_70661_as().func_226337_n_()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState castPredicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState summonPredicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idleController", 20.0f, this::idlePredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "castController", 1.0f, this::castPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "summonController", 1.0f, this::summonPredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    protected EntityWixie(EntityType<? extends AbstractFlyingCreature> type, World worldIn) {
        super(type, worldIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.addGoalsAfterConstructor();
    }

    public EntityWixie(World world, boolean isTamed, BlockPos pos) {
        super(ModEntities.ENTITY_WIXIE_TYPE, world);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.cauldronPos = pos;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, true);
        this.field_70180_af.func_187227_b(TAMED, (Object)isTamed);
        this.addGoalsAfterConstructor();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.cauldronPos != null && this.field_70170_p.func_175625_s(this.cauldronPos) instanceof WixieCauldronTile)) {
            this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p))), 99.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.inventoryBackoff > 0) {
            --this.inventoryBackoff;
        }
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new FindNextItemGoal(this)));
        list.add(new PrioritizedGoal(2, (Goal)new FindPotionGoal(this)));
        list.add(new PrioritizedGoal(1, (Goal)new CompleteCraftingGoal(this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(3, (Goal)new LookRandomlyGoal((MobEntity)this)));
        list.add(new PrioritizedGoal(2, (Goal)new FindNextItemGoal(this)));
        list.add(new PrioritizedGoal(2, (Goal)new FindPotionGoal(this)));
        list.add(new PrioritizedGoal(1, (Goal)new CompleteCraftingGoal(this)));
        return list;
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED) != false ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, world);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, Attributes.field_233822_e_.func_111110_b()).func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("summoner_x")) {
            this.cauldronPos = new BlockPos(tag.func_74762_e("summoner_x"), tag.func_74762_e("summoner_y"), tag.func_74762_e("summoner_z"));
        }
        this.field_70180_af.func_187227_b(TAMED, (Object)tag.func_74767_n("tamed"));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.cauldronPos != null) {
            tag.func_74768_a("summoner_x", this.cauldronPos.func_177958_n());
            tag.func_74768_a("summoner_y", this.cauldronPos.func_177956_o());
            tag.func_74768_a("summoner_z", this.cauldronPos.func_177952_p());
        }
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
    }

    @Override
    public void startAnimation(int arg) {
        if (arg == Animations.CAST.ordinal()) {
            AnimationController controller = (AnimationController)this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("castController");
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("cast", Boolean.valueOf(false)));
        } else if (arg == Animations.SUMMON_ITEM.ordinal()) {
            AnimationController controller = (AnimationController)this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("summonController");
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("summon_item", Boolean.valueOf(false)));
        }
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.WIXIE_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
        }
        super.func_70645_a(source);
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.WIXIE_CHARM);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack.func_77946_l()));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        }
        return true;
    }

    public static enum Animations {
        CAST,
        SUMMON_ITEM;

    }
}

