/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.entity.DrygmyEntity;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.hollingsworth.arsnouveau.common.entity.EntityEarthElemental;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import com.hollingsworth.arsnouveau.common.entity.EntityWardProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWhelp;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.LightningEntity;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="ars_nouveau")
public class ModEntities {
    public static EntityType<EntityProjectileSpell> SPELL_PROJ = null;
    public static EntityType<EntityAllyVex> ALLY_VEX = null;
    public static EntityType<EntityEvokerFangs> ENTITY_EVOKER_FANGS_ENTITY_TYPE = null;
    public static EntityType<EntityWhelp> ENTITY_WHELP_TYPE = null;
    public static EntityType<EntityCarbuncle> ENTITY_CARBUNCLE_TYPE = ModEntities.build("carbuncle", EntityType.Builder.func_220322_a(EntityCarbuncle::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.63f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntityFollowProjectile> ENTITY_FOLLOW_PROJ = null;
    public static EntityType<EntitySylph> ENTITY_SYLPH_TYPE = ModEntities.build("sylph", EntityType.Builder.func_220322_a(EntitySylph::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntityEarthElemental> ENTITY_EARTH_ELEMENTAL_TYPE = null;
    public static EntityType<EntityWixie> ENTITY_WIXIE_TYPE = null;
    public static EntityType<EntityFlyingItem> ENTITY_FLYING_ITEM = null;
    public static EntityType<EntityRitualProjectile> ENTITY_RITUAL = null;
    public static EntityType<WildenHunter> WILDEN_HUNTER = ModEntities.build("wilden_hunter", EntityType.Builder.func_220322_a(WildenHunter::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<EntitySpellArrow> ENTITY_SPELL_ARROW = null;
    public static EntityType<SummonWolf> SUMMON_WOLF = null;
    public static EntityType<WildenStalker> WILDEN_STALKER = ModEntities.build("wilden_stalker", EntityType.Builder.func_220322_a(WildenStalker::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<SummonHorse> SUMMON_HORSE = null;
    public static EntityType<WildenGuardian> WILDEN_GUARDIAN = ModEntities.build("wilden_guardian", EntityType.Builder.func_220322_a(WildenGuardian::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
    public static EntityType<LightningEntity> LIGHTNING_ENTITY = null;
    public static EntityType<EntityDummy> ENTITY_DUMMY = null;
    public static EntityType<DrygmyEntity> ENTITY_DRYGMY = null;
    public static EntityType<EntityWardProjectile> ENTITY_WARD = null;

    public static boolean canMonsterSpawnInLight(EntityType<? extends Entity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && ModEntities.isValidLightLevel(worldIn, pos, randomIn) && ModEntities.canSpawnOn(type, (IWorld)worldIn, reason, pos, randomIn) && !((List)Config.DIMENSION_BLACKLIST.get()).contains(worldIn.func_201672_e().func_234923_W_().func_240901_a_().toString());
    }

    public static boolean canSpawnOn(EntityType<? extends Entity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn);
    }

    public static boolean genericGroundSpawn(EntityType<? extends Entity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static boolean isValidLightLevel(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
        ResourceLocation registryName = new ResourceLocation("ars_nouveau", name);
        EntityType entityType = builder.func_206830_a(registryName.toString());
        entityType.setRegistryName(registryName);
        return entityType;
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            SPELL_PROJ = ModEntities.build("spell_proj", EntityType.Builder.func_220322_a(EntityProjectileSpell::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true).setUpdateInterval(120).setCustomClientFactory(EntityProjectileSpell::new));
            ENTITY_EVOKER_FANGS_ENTITY_TYPE = ModEntities.build("fangs", EntityType.Builder.func_220322_a(EntityEvokerFangs::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.8f).setUpdateInterval(60));
            ALLY_VEX = ModEntities.build("ally_vex", EntityType.Builder.func_220322_a(EntityAllyVex::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.4f, 0.8f).func_220320_c());
            ENTITY_WHELP_TYPE = ModEntities.build("whelp", EntityType.Builder.func_220322_a(EntityWhelp::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 0.63f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            ENTITY_FOLLOW_PROJ = ModEntities.build("follow_proj", EntityType.Builder.func_220322_a(EntityFollowProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityFollowProjectile::new));
            ENTITY_WIXIE_TYPE = ModEntities.build("wixie", EntityType.Builder.func_220322_a(EntityWixie::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 0.98f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            ENTITY_FLYING_ITEM = ModEntities.build("flying_item", EntityType.Builder.func_220322_a(EntityFlyingItem::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityFlyingItem::new));
            ENTITY_RITUAL = ModEntities.build("ritual", EntityType.Builder.func_220322_a(EntityRitualProjectile::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(60).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityRitualProjectile::new));
            ENTITY_SPELL_ARROW = ModEntities.build("spell_arrow", EntityType.Builder.func_220322_a(EntitySpellArrow::new, (EntityClassification)EntityClassification.MISC).func_233606_a_(20).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntitySpellArrow::new));
            SUMMON_WOLF = ModEntities.build("summon_wolf", EntityType.Builder.func_220322_a(SummonWolf::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).func_233606_a_(10));
            SUMMON_HORSE = ModEntities.build("summon_horse", EntityType.Builder.func_220322_a(SummonHorse::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
            ENTITY_DUMMY = ModEntities.build("dummy", EntityType.Builder.func_220322_a(EntityDummy::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 2.0f).setTrackingRange(10).setShouldReceiveVelocityUpdates(true));
            LIGHTNING_ENTITY = ModEntities.build("an_lightning", EntityType.Builder.func_220322_a(LightningEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.0f, 0.0f).func_233606_a_(16).func_233608_b_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(true).setUpdateInterval(60));
            ENTITY_DRYGMY = ModEntities.build("drygmy", EntityType.Builder.func_220322_a(DrygmyEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.85f).func_233606_a_(10));
            ENTITY_WARD = ModEntities.build("ward_entity", EntityType.Builder.func_220322_a(EntityWardProjectile::new, (EntityClassification)EntityClassification.MISC).func_233606_a_(20).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(EntityWardProjectile::new));
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{SPELL_PROJ, ENTITY_EVOKER_FANGS_ENTITY_TYPE, ALLY_VEX, ENTITY_WHELP_TYPE, ENTITY_CARBUNCLE_TYPE, ENTITY_SYLPH_TYPE, ENTITY_FOLLOW_PROJ, ENTITY_WIXIE_TYPE, ENTITY_FLYING_ITEM, ENTITY_RITUAL, WILDEN_HUNTER, ENTITY_SPELL_ARROW, SUMMON_WOLF, WILDEN_STALKER, SUMMON_HORSE, WILDEN_GUARDIAN, LIGHTNING_ENTITY, ENTITY_DUMMY, ENTITY_DRYGMY, ENTITY_WARD});
            GlobalEntityTypeAttributes.put(ENTITY_WHELP_TYPE, (AttributeModifierMap)EntityWhelp.attributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(ALLY_VEX, (AttributeModifierMap)VexEntity.func_234321_m_().func_233813_a_());
            GlobalEntityTypeAttributes.put(ENTITY_CARBUNCLE_TYPE, (AttributeModifierMap)EntityCarbuncle.attributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(ENTITY_SYLPH_TYPE, (AttributeModifierMap)EntitySylph.attributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(ENTITY_DRYGMY, (AttributeModifierMap)EntitySylph.attributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(ENTITY_WIXIE_TYPE, (AttributeModifierMap)EntityWixie.attributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(WILDEN_HUNTER, (AttributeModifierMap)WildenHunter.getModdedAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(WILDEN_STALKER, (AttributeModifierMap)WildenStalker.getModdedAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(SUMMON_WOLF, (AttributeModifierMap)WolfEntity.func_234233_eS_().func_233813_a_());
            GlobalEntityTypeAttributes.put(SUMMON_HORSE, (AttributeModifierMap)AbstractHorseEntity.func_234237_fg_().func_233813_a_());
            GlobalEntityTypeAttributes.put(WILDEN_GUARDIAN, (AttributeModifierMap)WildenGuardian.getModdedAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put(ENTITY_DUMMY, (AttributeModifierMap)MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233813_a_());
            EntitySpawnPlacementRegistry.func_209343_a(ENTITY_CARBUNCLE_TYPE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(ENTITY_SYLPH_TYPE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::genericGroundSpawn);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_GUARDIAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_HUNTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
            EntitySpawnPlacementRegistry.func_209343_a(WILDEN_STALKER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ModEntities::canMonsterSpawnInLight);
        }
    }
}

