/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.goal.guardian.LaserAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.wilden.WildenMeleeAttack;
import com.hollingsworth.arsnouveau.setup.Config;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WildenGuardian
extends MonsterEntity
implements IAnimatable,
IAnimationListener {
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public int laserCooldown;
    public int armorCooldown;
    public int armorTimeRemaining;
    public Vector3d orbitOffset = Vector3d.field_186680_a;
    public BlockPos orbitPosition = BlockPos.field_177992_a;
    private LivingEntity targetedEntity;
    public static final DataParameter<Boolean> isLaser = EntityDataManager.func_187226_a(WildenGuardian.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> IS_ARMORED = EntityDataManager.func_187226_a(WildenGuardian.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(WildenGuardian.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CLIENT_TIME = EntityDataManager.func_187226_a(WildenGuardian.class, (IDataSerializer)DataSerializers.field_187192_b);

    protected WildenGuardian(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (Goal)new WildenMeleeAttack((CreatureEntity)this, 0.8, true, Animations.ATTACK.ordinal(), () -> (Boolean)this.field_70180_af.func_187225_a(isLaser) == false));
        this.field_70714_bg.func_75776_a(4, (Goal)new LaserAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (((Boolean)Config.GUARDIAN_ATTACK_ANIMALS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.setClientAttackTime(0);
            this.targetedEntity = null;
        }
    }

    public void setClientAttackTime(int i) {
        this.field_70180_af.func_187227_b(CLIENT_TIME, (Object)i);
    }

    public int getClientAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(CLIENT_TIME);
    }

    public boolean getIsLaser() {
        return (Boolean)this.field_70180_af.func_187225_a(isLaser);
    }

    public void setLaser(boolean isLasering) {
        this.field_70180_af.func_187227_b(isLaser, (Object)isLasering);
    }

    public boolean isArmored() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ARMORED);
    }

    public void setArmored(boolean isArmored) {
        this.field_70180_af.func_187227_b(IS_ARMORED, (Object)isArmored);
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.field_70170_p.field_72995_K && this.armorCooldown == 0) {
            this.setArmored(true);
            this.armorCooldown = 500;
            this.armorTimeRemaining = 250;
        }
        if (!this.field_70170_p.field_72995_K && this.isArmored()) {
            damageAmount = (float)((double)damageAmount * 0.25);
            if (damageSrc.func_76346_g() != null) {
                damageSrc.func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)this), 3.0f);
            }
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.laserCooldown > 0) {
                --this.laserCooldown;
            }
            if (this.armorTimeRemaining > 0) {
                --this.armorTimeRemaining;
            }
            if (this.armorTimeRemaining == 0 && this.isArmored()) {
                this.setArmored(false);
            }
            if (this.armorCooldown > 0) {
                --this.armorCooldown;
            }
        }
        if (this.hasTargetedEntity() && this.getIsLaser()) {
            LivingEntity livingentity;
            if (this.getClientAttackTime() < this.getAttackDuration()) {
                this.setClientAttackTime(this.getClientAttackTime() + 1);
            }
            if ((livingentity = this.getTargetedEntity()) != null) {
                this.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
            }
        }
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller;
            if (arg == WildenHunter.Animations.ATTACK.ordinal()) {
                controller = (AnimationController)this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && (controller.getCurrentAnimation().animationName.equals("attack") || controller.getCurrentAnimation().animationName.equals("attack2") || controller.getCurrentAnimation().animationName.equals("howl"))) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("attack").addAnimation("idle"));
            }
            if (arg == WildenHunter.Animations.RAM.ordinal()) {
                controller = (AnimationController)this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("attack2")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("attack2").addAnimation("idle"));
            }
            if (arg == WildenHunter.Animations.HOWL.ordinal()) {
                controller = (AnimationController)this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("howl").addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(isLaser, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(CLIENT_TIME, (Object)0);
        this.field_70180_af.func_187214_a(IS_ARMORED, (Object)false);
    }

    private <E extends Entity> PlayState attackPredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 1.0f, this::attackPredicate));
    }

    public int getAttackDuration() {
        return 80;
    }

    public float getAttackAnimationScale(float p_175477_1_) {
        return ((float)this.getClientAttackTime() + p_175477_1_) / (float)this.getAttackDuration();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.armorCooldown = compound.func_74762_e("armorCooldown");
        this.armorTimeRemaining = compound.func_74762_e("armorTimeRemaining");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("armorCooldown", this.armorCooldown);
        compound.func_74768_a("armorTimeRemaining", this.armorTimeRemaining);
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static AttributeModifierMap.MutableAttribute getModdedAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, (double)0.6f).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233823_f_, 4.5).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    static enum Animations {
        ATTACK;

    }
}

