/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StoreItemGoal
extends Goal {
    private final EntityCarbuncle entityCarbuncle;
    BlockPos storePos;
    boolean unreachable;

    public StoreItemGoal(EntityCarbuncle entityCarbuncle) {
        this.entityCarbuncle = entityCarbuncle;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public void func_75251_c() {
        this.storePos = null;
        this.unreachable = false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.storePos = this.entityCarbuncle.getValidStorePos(this.entityCarbuncle.getHeldStack());
        if (this.storePos != null && !this.entityCarbuncle.getHeldStack().func_190926_b()) {
            Path path = this.entityCarbuncle.func_70661_as().func_179680_a(this.storePos, 1);
            this.entityCarbuncle.func_70661_as().func_75484_a(path, 1.2);
        }
    }

    public void func_75246_d() {
        if (!this.entityCarbuncle.getHeldStack().func_190926_b() && this.storePos != null && BlockUtil.distanceFrom(this.entityCarbuncle.func_233580_cy_(), this.storePos) < 2.0) {
            World world = this.entityCarbuncle.field_70170_p;
            TileEntity tileEntity = world.func_175625_s(this.storePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                ItemStack oldStack = new ItemStack((IItemProvider)this.entityCarbuncle.getHeldStack().func_77973_b(), this.entityCarbuncle.getHeldStack().func_190916_E());
                ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.entityCarbuncle.getHeldStack(), (boolean)false);
                if (left.equals(oldStack)) {
                    return;
                }
                if (world instanceof ServerWorld) {
                    OpenChestEvent event = new OpenChestEvent(FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)), this.storePos, 20);
                    event.open();
                    EventQueue.getInstance().addEvent(event);
                }
                this.entityCarbuncle.setHeldStack(left);
                this.entityCarbuncle.backOff = 5;
                this.entityCarbuncle.func_184212_Q().func_187227_b(EntityCarbuncle.HOP, (Object)false);
                return;
            }
        }
        if (this.storePos != null && !this.entityCarbuncle.getHeldStack().func_190926_b()) {
            this.setPath(this.storePos.func_177958_n(), this.storePos.func_177956_o(), this.storePos.func_177952_p(), 1.2);
            this.entityCarbuncle.func_184212_Q().func_187227_b(EntityCarbuncle.HOP, (Object)true);
            super.func_75246_d();
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        Path path = this.entityCarbuncle.func_70661_as().func_225466_a(x + 0.5, y + 1.0, z + 0.5, 1);
        if (path == null || !path.func_224771_h()) {
            this.unreachable = true;
        }
        this.entityCarbuncle.func_70661_as().func_75484_a(path, speedIn);
    }

    public boolean func_75253_b() {
        return !this.unreachable && this.entityCarbuncle.isTamed() && this.entityCarbuncle.getHeldStack() != null && !this.entityCarbuncle.getHeldStack().func_190926_b() && this.entityCarbuncle.backOff == 0 && this.storePos != null;
    }

    public boolean func_75250_a() {
        return this.entityCarbuncle.isTamed() && this.entityCarbuncle.getHeldStack() != null && !this.entityCarbuncle.getHeldStack().func_190926_b() && this.entityCarbuncle.backOff == 0;
    }
}

