/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.sylph;

import com.hollingsworth.arsnouveau.common.entity.EntitySylph;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EvaluateGroveGoal
extends Goal {
    private final EntitySylph sylph;
    private final int ticksToNextEval;

    public EvaluateGroveGoal(EntitySylph sylph, int tickFreq) {
        this.sylph = sylph;
        this.ticksToNextEval = tickFreq;
    }

    public boolean func_75250_a() {
        return this.sylph.crystalPos != null && (this.sylph.timeUntilEvaluation <= 0 || this.sylph.genTable == null);
    }

    public static int getScore(BlockState state) {
        if (state.func_185904_a() == Material.field_151579_a) {
            return 0;
        }
        if (state == Blocks.field_150355_j.func_176223_P() || state == Blocks.field_196658_i.func_176223_P() || state == Blocks.field_196661_l.func_176223_P() || state == Blocks.field_185774_da.func_176223_P()) {
            return 1;
        }
        if (state.func_177230_c() instanceof BushBlock) {
            return 2;
        }
        if (state.func_177230_c() instanceof StemGrownBlock) {
            return 2;
        }
        if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
            return 2;
        }
        if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) || state.func_177230_c() instanceof LeavesBlock) {
            return 1;
        }
        if (state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l) {
            return 1;
        }
        if (state.func_177230_c() instanceof IGrowable) {
            return 1;
        }
        return 0;
    }

    public void func_75249_e() {
        World world = this.sylph.func_130014_f_();
        HashMap<BlockState, Integer> defaultMap = new HashMap<BlockState, Integer>();
        HashMap<BlockState, Integer> dropMap = new HashMap<BlockState, Integer>();
        int score = 0;
        for (BlockPos b : BlockPos.func_218278_a((BlockPos)this.sylph.crystalPos.func_177964_d(10).func_177985_f(10).func_177979_c(1), (BlockPos)this.sylph.crystalPos.func_177970_e(10).func_177965_g(10).func_177981_b(30))) {
            BlockState state;
            BlockState defaultState;
            int points;
            if (b.func_177956_o() >= 256 || (points = EvaluateGroveGoal.getScore(defaultState = (state = world.func_180495_p(b)).func_177230_c().func_176223_P())) == 0) continue;
            if (!defaultMap.containsKey(defaultState)) {
                defaultMap.put(defaultState, 0);
            }
            if (!dropMap.containsKey(state)) {
                dropMap.put(state, 0);
            }
            if (!state.hasTileEntity()) {
                dropMap.put(state, (Integer)dropMap.get(state) + 1);
            }
            defaultMap.put(defaultState, (Integer)defaultMap.get(defaultState) + 1);
            score += (Integer)defaultMap.get(defaultState) <= 50 ? EvaluateGroveGoal.getScore(defaultState) : 0;
        }
        this.sylph.func_184212_Q().func_187227_b(EntitySylph.MOOD_SCORE, (Object)score);
        this.sylph.timeUntilEvaluation = this.ticksToNextEval;
        this.sylph.genTable = dropMap;
        this.sylph.scoreMap = defaultMap;
        this.sylph.diversityScore = defaultMap.keySet().size();
    }
}

