/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.sylph;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.DistanceRestrictedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.sylph.EvaluateGroveGoal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.block.material.Material;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class InspectPlantGoal
extends DistanceRestrictedGoal {
    MobEntity entity;
    BlockPos pos;
    int timeLooking;
    int timePerforming;

    public InspectPlantGoal(MobEntity entity, Supplier<BlockPos> from, int maxDistanceFrom) {
        super(from, maxDistanceFrom);
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.entity = entity;
    }

    public boolean hasVisibleSide(BlockPos pos) {
        for (Direction d : Direction.values()) {
            if (this.entity.field_70170_p.func_180495_p(pos.func_177972_a(d)).func_185904_a() != Material.field_151579_a) continue;
            return true;
        }
        return false;
    }

    public void func_75246_d() {
        if (this.pos == null) {
            return;
        }
        --this.timePerforming;
        if (BlockUtil.distanceFrom(this.entity.func_233580_cy_(), this.pos) > 1.5) {
            this.entity.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 1.2);
        } else {
            ServerWorld world = (ServerWorld)this.entity.field_70170_p;
            this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()));
            if (world.field_73012_v.nextInt(20) == 0) {
                world.func_195598_a((IParticleData)ParticleTypes.field_197633_z, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 1.1, (double)this.pos.func_177952_p() + 0.5, 1, ParticleUtil.inRange(-0.2, 0.2), 0.0, ParticleUtil.inRange(-0.2, 0.2), 0.01);
            }
            --this.timeLooking;
        }
    }

    public boolean func_75253_b() {
        return this.pos != null && this.timeLooking > 0 && this.timePerforming > 0;
    }

    public boolean func_75250_a() {
        return this.entity.func_130014_f_().field_73012_v.nextInt(100) <= 2;
    }

    public void func_75249_e() {
        int range = 4;
        ArrayList list = new ArrayList();
        BlockPos.func_218281_b((BlockPos)this.entity.func_233580_cy_().func_177982_a(range, range, range), (BlockPos)this.entity.func_233580_cy_().func_177982_a(-range, -range, -range)).forEach(bp -> {
            if (EvaluateGroveGoal.getScore(this.entity.field_70170_p.func_180495_p(bp)) > 0 && this.hasVisibleSide((BlockPos)bp) && this.isInRange((BlockPos)bp)) {
                list.add(bp.func_185334_h());
            }
        });
        if (list.isEmpty()) {
            return;
        }
        this.pos = (BlockPos)list.get(this.entity.field_70170_p.field_73012_v.nextInt(list.size()));
        this.timeLooking = 60;
        this.timePerforming = 240;
    }
}

