/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wixie;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FindPotionGoal
extends Goal {
    EntityWixie wixie;
    BlockPos movePos;
    boolean found;
    Potion potionNeeded;

    public FindPotionGoal(EntityWixie wixie) {
        this.wixie = wixie;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void func_75249_e() {
        TileEntity tileEntity = this.wixie.field_70170_p.func_175625_s(this.wixie.cauldronPos);
        this.found = false;
        if (tileEntity instanceof WixieCauldronTile) {
            this.potionNeeded = ((WixieCauldronTile)tileEntity).getNeededPotion();
            this.movePos = ((WixieCauldronTile)tileEntity).findNeededPotion(this.potionNeeded, 300);
        } else {
            this.found = true;
        }
        if (this.movePos == null) {
            this.found = true;
        }
    }

    public void func_75246_d() {
        if (this.found) {
            return;
        }
        if (this.movePos != null && BlockUtil.distanceFrom(this.wixie.func_233580_cy_(), this.movePos.func_177984_a()) < 1.5) {
            WixieCauldronTile tile = (WixieCauldronTile)this.wixie.func_130014_f_().func_175625_s(this.wixie.cauldronPos);
            World world = this.wixie.func_130014_f_();
            if (tile == null) {
                this.found = true;
                return;
            }
            PotionJarTile jar = (PotionJarTile)world.func_175625_s(this.movePos);
            if (jar == null) {
                this.found = true;
                return;
            }
            jar.setFill(jar.getCurrentFill() - 300);
            tile.givePotion();
            Networking.sendToNearby(world, (Entity)this.wixie, (Object)new PacketAnimEntity(this.wixie.func_145782_y(), EntityWixie.Animations.SUMMON_ITEM.ordinal()));
            int color = jar.getColor();
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            int a = color >> 24 & 0xFF;
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, this.movePos, this.wixie.cauldronPos, r, g, b);
            world.func_217376_c((Entity)aoeProjectile);
            this.found = true;
        }
        if (this.movePos != null && !this.found) {
            this.setPath(this.movePos.func_177958_n(), this.movePos.func_177956_o() + 1, this.movePos.func_177952_p(), 1.2);
        }
    }

    public boolean func_75250_a() {
        if (this.wixie.cauldronPos == null) {
            return false;
        }
        TileEntity tileEntity = this.wixie.field_70170_p.func_175625_s(this.wixie.cauldronPos);
        return this.wixie.inventoryBackoff == 0 && tileEntity instanceof WixieCauldronTile && ((WixieCauldronTile)tileEntity).hasMana && ((WixieCauldronTile)tileEntity).needsPotion() && !((WixieCauldronTile)tileEntity).isOff;
    }

    public boolean func_75253_b() {
        return !this.found;
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.wixie.func_70661_as().func_75484_a(this.wixie.func_70661_as().func_225466_a(x + 0.5, y + 0.5, z + 0.5, 0), speedIn);
    }

    public void func_75251_c() {
        this.potionNeeded = Potions.field_185229_a;
        this.found = false;
    }
}

