/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.LavaLily;
import com.hollingsworth.arsnouveau.common.command.DataDumpCommand;
import com.hollingsworth.arsnouveau.common.command.ResetCommand;
import com.hollingsworth.arsnouveau.common.compat.CaelusHandler;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemPickupEvent(EntityItemPickupEvent event) {
        ItemStack pickingUp;
        PlayerEntity player = event.getPlayer();
        boolean voided = VoidJar.tryVoiding(player, pickingUp = event.getItem().func_92059_d());
        if (voided) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingHurtEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K && e.getEntityLiving() instanceof PlayerEntity && e.getEntityLiving().func_184585_cz() && e.getEntityLiving().func_233631_a_((Item)ItemsRegistry.ENCHANTERS_SHIELD)) {
            e.getEntityLiving().func_195064_c(new EffectInstance((Effect)ModPotions.MANA_REGEN_EFFECT, 200, 1));
        }
    }

    @SubscribeEvent
    public static void livingAttackEvent(LivingAttackEvent e) {
        World world;
        if (e.getSource() == DamageSource.field_190095_e && e.getEntityLiving() != null && !e.getEntity().func_130014_f_().field_72995_K && (world = e.getEntity().field_70170_p).func_180495_p(e.getEntityLiving().func_233580_cy_()).func_177230_c() instanceof LavaLily) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving() == null || e.getEntityLiving().func_70660_b((Effect)ModPotions.SNARE_EFFECT) == null) {
            return;
        }
        e.getEntityLiving().func_213293_j(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        String book_tag;
        if (e.getEntityLiving().func_130014_f_().field_72995_K || !((Boolean)Config.SPAWN_BOOK.get()).booleanValue()) {
            return;
        }
        CompoundNBT tag = e.getPlayer().getPersistentData().func_74775_l("PlayerPersisted");
        if (tag.func_74767_n(book_tag = "an_book_")) {
            return;
        }
        LivingEntity entity = e.getEntityLiving();
        e.getEntityLiving().func_130014_f_().func_217376_c((Entity)new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemsRegistry.wornNotebook)));
        tag.func_74757_a(book_tag, true);
        e.getPlayer().getPersistentData().func_218657_a("PlayerPersisted", (INBT)tag);
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlideTick(TickEvent.PlayerTickEvent event) {
        if (ArsNouveau.caelusLoaded && event.player.func_70644_a((Effect)ModPotions.GLIDE_EFFECT)) {
            CaelusHandler.setFlying(event.player);
        }
    }

    @SubscribeEvent
    public static void playerDamaged(LivingHurtEvent e) {
        if (e.getEntityLiving() != null && e.getEntityLiving().func_193076_bZ().containsKey((Object)ModPotions.SHIELD_POTION) && (e.getSource() == DamageSource.field_76376_m || e.getSource() == DamageSource.field_76377_j || e.getSource() instanceof EntityDamageSource)) {
            float damage = e.getAmount() - (1.0f + 0.5f * (float)((EffectInstance)e.getEntityLiving().func_193076_bZ().get((Object)ModPotions.SHIELD_POTION)).func_76458_c());
            e.setAmount(Math.max(0.0f, damage));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent e) {
        LivingEntity entity;
        if (e.getEntityLiving() != null && e.getSource() == DamageSource.field_180137_b && e.getEntityLiving().func_70660_b((Effect)ModPotions.SHOCKED_EFFECT) != null) {
            float damage = e.getAmount() + 3.0f + 3.0f * (float)e.getEntityLiving().func_70660_b((Effect)ModPotions.SHOCKED_EFFECT).func_76458_c();
            e.setAmount(Math.max(0.0f, damage));
        }
        if ((entity = e.getEntityLiving()) != null && entity.func_70660_b((Effect)ModPotions.HEX_EFFECT) != null && (entity.func_70660_b(Effects.field_76436_u) != null || entity.func_70660_b(Effects.field_82731_v) != null || entity.func_70027_ad())) {
            e.setAmount(e.getAmount() + 0.5f + 0.33f * (float)entity.func_70660_b((Effect)ModPotions.HEX_EFFECT).func_76458_c());
        }
    }

    @SubscribeEvent
    public static void entityHeal(LivingHealEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity != null && entity.func_70660_b((Effect)ModPotions.HEX_EFFECT) != null) {
            e.setAmount(e.getAmount() / 2.0f);
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent event) {
        LivingEntity entity;
        if (event.rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)event.rayTraceResult).func_216348_a() instanceof LivingEntity && (entity = (LivingEntity)((EntityRayTraceResult)event.rayTraceResult).func_216348_a()) instanceof WitchEntity && entity.func_110143_aJ() <= entity.func_110138_aP() / 2.0f) {
            entity.func_70106_y();
            ParticleUtil.spawnPoof((ServerWorld)event.world, entity.func_233580_cy_());
            event.world.func_217376_c((Entity)new ItemEntity(event.world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemsRegistry.WIXIE_SHARD)));
        }
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        ResetCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        DataDumpCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private EventHandler() {
    }
}

