/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.renderer.item.SwordRenderer;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EnchantersSword
extends SwordItem
implements ICasterTool,
IAnimatable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EnchantersSword(IItemTier iItemTier, int baseDamage, float baseAttackSpeed) {
        super(iItemTier, baseDamage, baseAttackSpeed, ItemsRegistry.defaultItemProperties().func_200917_a(1).setISTER(() -> SwordRenderer::new));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(stack, world, entity, p_77663_4_, p_77663_5_);
        if (world.func_201670_d() || world.func_82737_E() % 200L != 0L || stack.func_77952_i() == 0 || !(entity instanceof PlayerEntity)) {
            return;
        }
        ManaCapability.getMana((LivingEntity)entity).ifPresent(mana -> {
            if (mana.getCurrentMana() > 20.0) {
                mana.removeMana(20.0);
                stack.func_196085_b(stack.func_77952_i() - 1);
            }
        });
    }

    public EnchantersSword(IItemTier iItemTier, int baseDamage, float baseAttackSpeed, Item.Properties properties) {
        super(iItemTier, baseDamage, baseAttackSpeed, properties);
    }

    @Override
    public boolean isScribedSpellValid(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(PlayerEntity player) {
        PortUtil.sendMessageNoSpam((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.sword.invalid"));
    }

    @Override
    public boolean setSpell(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodTouch.INSTANCE);
        recipe.addAll(spell.recipe);
        recipe.add(AugmentAmplify.INSTANCE);
        spell.recipe = recipe;
        spell.setCost(spell.getCastingCost() - AugmentAmplify.INSTANCE.getManaCost());
        return ICasterTool.super.setSpell(caster, player, hand, stack, spell);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity player) {
        ISpellCaster caster = this.getSpellCaster(stack);
        SpellResolver resolver = new SpellResolver(new SpellContext(caster.getSpell(), player).withColors(caster.getColor()));
        EntityRayTraceResult entityRes = new EntityRayTraceResult((Entity)target);
        resolver.onCastOnEntity(stack, player, (LivingEntity)entityRes.func_216348_a(), Hand.MAIN_HAND);
        return super.func_77644_a(stack, target, player);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        super.func_77624_a(stack, worldIn, tooltip2, flagIn);
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

