/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Glyph
extends ModItem {
    public AbstractSpellPart spellPart;

    public Glyph(String registryName, AbstractSpellPart part) {
        super(registryName);
        this.spellPart = part;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (!Config.isSpellEnabled(this.spellPart.tag)) {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.spell.disabled"), Util.field_240973_b_);
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        playerIn.field_71071_by.field_70462_a.forEach(itemStack -> {
            if (itemStack.func_77973_b() instanceof SpellBook) {
                if (SpellBook.getUnlockedSpells(itemStack.func_77978_p()).contains(this.spellPart)) {
                    playerIn.func_145747_a((ITextComponent)new StringTextComponent("You already know this spell!"), Util.field_240973_b_);
                    return;
                }
                SpellBook.unlockSpell(itemStack.func_77978_p(), this.spellPart.getTag());
                playerIn.func_184586_b(handIn).func_190918_g(1);
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("Unlocked " + this.spellPart.getName()), Util.field_240973_b_);
            }
        });
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        if (this.spellPart != null && !Config.isSpellEnabled(this.spellPart.tag)) {
            tooltip2.add((ITextComponent)new StringTextComponent("Disabled. Cannot be used."));
        }
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:glyph_recipe");
        jsonobject.addProperty("tier", this.spellPart.getTier().toString());
        if (this.spellPart.getCraftingReagent() != null) {
            jsonobject.addProperty("input", this.spellPart.getCraftingReagent().getRegistryName().toString());
        }
        jsonobject.addProperty("output", this.getRegistryName().toString());
        return jsonobject;
    }
}

