/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.IRitualCaster;
import com.hollingsworth.arsnouveau.api.ritual.RitualCaster;
import com.hollingsworth.arsnouveau.common.block.RitualBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenRitualBook;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class RitualBook
extends ModItem {
    public RitualBook() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ArsNouveau.itemGroup));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() instanceof RitualBlock) {
            IRitualCaster caster = RitualBook.getRitualCaster(context.func_195996_i());
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            RitualTile tile = (RitualTile)world.func_175625_s(pos);
            tile.setRitual(caster.getSelectedRitual());
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && playerIn instanceof ServerPlayerEntity) {
            RitualCaster caster = RitualCaster.deserialize(playerIn.func_184586_b(handIn));
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketOpenRitualBook(player.func_184586_b(handIn).func_196082_o(), caster.getUnlockedRitualIDs(), handIn == Hand.MAIN_HAND));
        }
        return new ActionResult(ActionResultType.CONSUME, (Object)playerIn.func_184586_b(handIn));
    }

    public static void setRitualID(ItemStack stack, String ID) {
        RitualBook.getRitualCaster(stack).setRitual(ID);
    }

    public static IRitualCaster getRitualCaster(ItemStack stack) {
        return RitualCaster.deserialize(stack);
    }

    @Nullable
    public static AbstractRitual getSelectedRitual(ItemStack stack) {
        return ArsNouveauAPI.getInstance().getRitual(RitualCaster.deserialize(stack).getSelectedRitual());
    }

    public static void unlockRitual(ItemStack stack, String ritualID) {
        RitualBook.getRitualCaster(stack).unlockRitual(ritualID);
    }

    public static boolean containsRitual(ItemStack stack, String ritualID) {
        return RitualBook.getRitualCaster(stack).getUnlockedRitualIDs().contains(ritualID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack != null && stack.func_77942_o()) {
            tooltip.add((ITextComponent)new StringTextComponent(RitualBook.getSelectedRitual(stack).getName()));
        }
    }
}

