/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.client.gui.book.GuiRitualBook;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketOpenRitualBook {
    public CompoundNBT tag;
    public List<String> unlockedRituals;
    public boolean isMainhand;

    public PacketOpenRitualBook(CompoundNBT tag, List<String> unlockedRituals, boolean isMainhand) {
        this.tag = tag;
        this.unlockedRituals = unlockedRituals;
        this.isMainhand = isMainhand;
    }

    public PacketOpenRitualBook(PacketBuffer buf) {
        this.tag = buf.func_150793_b();
        int num = buf.readInt();
        this.unlockedRituals = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            this.unlockedRituals.add(buf.func_150789_c(Short.MAX_VALUE));
        }
        this.isMainhand = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(this.tag);
        buf.writeInt(this.unlockedRituals.size());
        for (String unlockedRitual : this.unlockedRituals) {
            buf.func_180714_a(unlockedRitual);
        }
        buf.writeBoolean(this.isMainhand);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> GuiRitualBook.open(ArsNouveauAPI.getInstance(), this.unlockedRituals, this.isMainhand));
        ctx.get().setPacketHandled(true);
    }
}

