/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class RitualHealing
extends AbstractRitual {
    @Override
    protected void tick() {
        if (this.getWorld().field_72995_K) {
            ParticleUtil.spawnRitualAreaEffect(this.tile, this.rand, this.getCenterColor(), 5);
        } else if (this.getWorld().func_82737_E() % 100L == 0L) {
            List entities = this.getWorld().func_217357_a(LivingEntity.class, new AxisAlignedBB(this.getPos()).func_186662_g(5.0));
            Optional<LivingEntity> player = entities.stream().filter(e -> e instanceof PlayerEntity).findFirst();
            boolean didWorkOnce = false;
            for (LivingEntity a : entities) {
                if (a instanceof ZombieVillagerEntity) {
                    ((ZombieVillagerEntity)a).func_191991_a(player.isPresent() ? player.get().func_110124_au() : null, 0);
                    didWorkOnce = true;
                    continue;
                }
                if (!(a.func_110143_aJ() < a.func_110138_aP()) && !a.func_70662_br()) continue;
                if (a.func_70662_br()) {
                    FakePlayer player1 = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.getWorld()));
                    a.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player1).func_82726_p(), 10.0f);
                } else {
                    a.func_70691_i(10.0f);
                }
                didWorkOnce = true;
            }
            if (didWorkOnce) {
                this.setNeedsMana(true);
            }
        }
    }

    @Override
    public String getID() {
        return "restoration";
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(20, 240, 240, this.rand);
    }

    @Override
    public String getLangName() {
        return "Restoration";
    }

    @Override
    public String getLangDescription() {
        return "Heals nearby entities or harms undead over time. Additionally, Zombie Villagers will be instantly cured, and the resulting villager will offer discounts if a player was nearby. This ritual requires mana to operate.";
    }

    @Override
    public int getManaCost() {
        return 200;
    }
}

