/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class RitualOvergrowth
extends AbstractRitual {
    @Override
    protected void tick() {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (this.getWorld().field_72995_K) {
            ParticleUtil.spawnRitualAreaEffect(this.tile, this.rand, this.getCenterColor(), 5);
        } else {
            if (this.getWorld().func_82737_E() % 200L != 0L) {
                return;
            }
            if (this.isAnimalGrowth()) {
                List animals = this.getWorld().func_217357_a(AgeableEntity.class, new AxisAlignedBB(this.getPos()).func_186662_g(5.0));
                boolean didWorkOnce = false;
                for (AgeableEntity a : animals) {
                    if (!a.func_70631_g_()) continue;
                    a.func_175501_a(500, true);
                    didWorkOnce = true;
                }
                if (didWorkOnce) {
                    this.setNeedsMana(true);
                }
            } else {
                int range = 5;
                boolean didWorkOnce = false;
                for (BlockPos b : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(range, -1, range), (BlockPos)pos.func_177982_a(-range, 1, -range))) {
                    if (this.rand.nextInt(25) != 0 || !BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)world, (BlockPos)b, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)))) continue;
                    didWorkOnce = true;
                }
                if (didWorkOnce) {
                    this.setNeedsMana(true);
                }
            }
        }
    }

    public boolean isAnimalGrowth() {
        return this.didConsumeItem(Items.field_221964_gn);
    }

    @Override
    public int getManaCost() {
        return 500;
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && stack.func_77973_b() == Items.field_221964_gn;
    }

    @Override
    public String getLangName() {
        return "Overgrowth";
    }

    @Override
    public String getLangDescription() {
        return "Occasionally bone meals blocks in the area around it. This ritual requires Mana to operate. If augmented with a Bone Block, this ritual will instead force baby animals to grow faster.";
    }

    @Override
    public String getID() {
        return "overgrowth";
    }

    @Override
    public ParticleColor getCenterColor() {
        return ParticleColor.makeRandomColor(20, 255, 20, this.rand);
    }
}

