/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectColdSnap
extends AbstractEffect {
    public static EffectColdSnap INSTANCE = new EffectColdSnap();

    private EffectColdSnap() {
        super("cold_snap", "Cold Snap");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, augments, spellContext);
        Entity entity = rayTraceResult.func_216348_a();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Vector3d vec = this.safelyGetHitPos((RayTraceResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * (double)this.getAmplificationBonus(augments));
        int range = 3 + EffectColdSnap.getBuffCount(augments, AugmentAOE.class);
        int snareSec = (Integer)this.POTION_TIME.get() + (Integer)this.EXTEND_TIME.get() * this.getDurationModifier(augments);
        if (!this.canDamage(livingEntity)) {
            return;
        }
        this.damage(vec, world, shooter, augments, damage, snareSec, livingEntity);
        for (Entity e : world.func_217357_a(LivingEntity.class, new AxisAlignedBB(livingEntity.func_233580_cy_().func_177964_d(range).func_177965_g(range).func_177981_b(range), livingEntity.func_233580_cy_().func_177970_e(range).func_177985_f(range).func_177979_c(range)))) {
            if (e.equals((Object)livingEntity) || !(e instanceof LivingEntity)) continue;
            if (((LivingEntity)e).func_70660_b(Effects.field_76421_d) != null || e.func_70026_G()) {
                vec = e.func_213303_ch();
                this.damage(vec, world, shooter, augments, damage, snareSec, (LivingEntity)e);
                continue;
            }
            ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76421_d, 20 * snareSec, this.getAmplificationBonus(augments)));
        }
    }

    public boolean canDamage(LivingEntity livingEntity) {
        return livingEntity.func_70026_G() || livingEntity.func_70660_b(Effects.field_76421_d) != null;
    }

    public void damage(Vector3d vec, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, float damage, int snareTime, LivingEntity livingEntity) {
        this.dealDamage(world, shooter, damage, augments, (Entity)livingEntity, this.buildDamageSource(world, shooter).func_82726_p());
        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197602_M, vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, 50, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
        livingEntity.func_195064_c(new EffectInstance((Effect)ModPotions.SNARE_EFFECT, 20 * snareTime));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 2.5);
        this.addPotionConfig(builder, 5);
        this.addExtendTimeConfig(builder, 1);
    }

    @Override
    public int getManaCost() {
        return 30;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Snares and causes a burst of damage to an entity that is afflicted by Slowness or is wet. Nearby enemies that are not afflicted by Slow will be slowed. Nearby Enemies afflicted by Slow or wetness will also be hit by Cold Snap. Can be augmented using Amplify, Extend Time, and AOE.";
    }

    @Override
    public Item getCraftingReagent() {
        return ArsNouveauAPI.getInstance().getGlyphItem(EffectFreeze.INSTANCE);
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }
}

