/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectConjureWater
extends AbstractEffect {
    public static EffectConjureWater INSTANCE = new EffectConjureWater();

    private EffectConjureWater() {
        super("conjure_water", "Conjure Water");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        Entity entity;
        if (rayTraceResult instanceof EntityRayTraceResult && (entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a()).func_70027_ad()) {
            entity.func_70066_B();
        }
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        int aoeBuff = EffectConjureWater.getBuffCount(augments, AugmentAOE.class);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, aoeBuff, EffectConjureWater.getBuffCount(augments, AugmentPierce.class));
        BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
        if (world.func_230315_m_().func_236040_e_()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            BlockPos hitPos = pos1.func_177972_a(result.func_216354_b());
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerWorld)world), world, pos1) || !world.func_180495_p(hitPos).func_227032_a_((Fluid)Fluids.field_204546_a)) continue;
            world.func_175656_a(hitPos, Blocks.field_150355_j.func_176223_P());
        }
    }

    @Override
    public int getManaCost() {
        return 80;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Places water at a location. Can be augmented with AOE.";
    }

    @Override
    public Item getCraftingReagent() {
        return Items.field_151131_as;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }
}

