/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EffectCraft
extends AbstractEffect {
    public static EffectCraft INSTANCE = new EffectCraft();
    private static final ITextComponent CONTAINER_NAME = new TranslationTextComponent("container.crafting");

    private EffectCraft() {
        super("craft", "Craft");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (shooter instanceof PlayerEntity && this.isRealPlayer(shooter)) {
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            playerEntity.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, player) -> new CustomWorkbench(id, inventory, IWorldPosCallable.func_221488_a((World)player.func_130014_f_(), (BlockPos)player.func_233580_cy_())), CONTAINER_NAME));
        }
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    public Item getCraftingReagent() {
        return Items.field_221734_cc;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Opens the crafting menu.";
    }

    public static class CustomWorkbench
    extends WorkbenchContainer {
        public CustomWorkbench(int id, PlayerInventory playerInventory) {
            super(id, playerInventory);
        }

        public CustomWorkbench(int id, PlayerInventory playerInventory, IWorldPosCallable p_i50090_3_) {
            super(id, playerInventory, p_i50090_3_);
        }

        public boolean func_75145_c(PlayerEntity playerIn) {
            return true;
        }
    }
}

