/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.IForgeShearable;

public class EffectCut
extends AbstractEffect {
    public static EffectCut INSTANCE = new EffectCut();

    private EffectCut() {
        super("cut", "Cut");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        Entity entity = rayTraceResult.func_216348_a();
        if (entity instanceof IForgeShearable) {
            IForgeShearable shearable = (IForgeShearable)entity;
            ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
            this.applyEnchantments(augments, shears);
            if (shearable.isShearable(shears, world, entity.func_233580_cy_())) {
                List items = shearable.onSheared(this.getPlayer(shooter, (ServerWorld)world), shears, world, entity.func_233580_cy_(), EffectCut.getBuffCount(augments, AugmentFortune.class));
                items.forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), i)));
            }
        } else {
            this.dealDamage(world, shooter, (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * (double)this.getAmplificationBonus(augments)), augments, entity, DamageSource.func_76365_a((PlayerEntity)this.getPlayer(shooter, (ServerWorld)world)));
        }
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.func_216350_a(), rayTraceResult, EffectCut.getBuffCount(augments, AugmentAOE.class), EffectCut.getBuffCount(augments, AugmentPierce.class))) {
            IForgeShearable shearable;
            ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
            this.applyEnchantments(augments, shears);
            if (world.func_180495_p(p).func_177230_c() instanceof IForgeShearable && (shearable = (IForgeShearable)world.func_180495_p(p).func_177230_c()).isShearable(shears, world, p)) {
                List items = shearable.onSheared(this.getPlayer(shooter, (ServerWorld)world), shears, world, p, EffectCut.getBuffCount(augments, AugmentFortune.class));
                items.forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), i)));
            }
            ANFakePlayer entity = new ANFakePlayer((ServerWorld)world);
            entity.func_184611_a(Hand.MAIN_HAND, shears);
            entity.func_70107_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            world.func_180495_p(p).func_227031_a_(world, (PlayerEntity)entity, Hand.MAIN_HAND, rayTraceResult);
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 1.0);
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentExtract.INSTANCE, AugmentFortune.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Shears entities and blocks, or damages non-shearable entities for a small amount. Costs nothing.";
    }

    @Override
    public int getManaCost() {
        return 0;
    }

    @Override
    public Item getCraftingReagent() {
        return Items.field_151097_aZ;
    }
}

