/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;

public class EffectExchange
extends AbstractEffect {
    public static EffectExchange INSTANCE = new EffectExchange();

    private EffectExchange() {
        super("exchange", "Exchange");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            this.resolveBlockHit(rayTraceResult, world, shooter, augments, spellContext);
        } else if (rayTraceResult instanceof EntityRayTraceResult) {
            this.resolveEntityHit(rayTraceResult, world, shooter, augments, spellContext);
        }
    }

    public void resolveEntityHit(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
        Entity entity = entityRayTraceResult.func_216348_a();
        if (shooter != null) {
            Vector3d origLoc = shooter.field_233557_ao_;
            if (this.isNotFakePlayer(shooter)) {
                shooter.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }
            if (entity instanceof LivingEntity && this.isNotFakePlayer((LivingEntity)entity)) {
                entity.func_70634_a(origLoc.func_82615_a(), origLoc.func_82617_b(), origLoc.func_82616_c());
            }
        }
    }

    public void resolveBlockHit(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        int aoeBuff = EffectExchange.getBuffCount(augments, AugmentAOE.class);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, aoeBuff, EffectExchange.getBuffCount(augments, AugmentPierce.class));
        BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
        BlockState origState = world.func_180495_p(result.func_216350_a());
        PlayerEntity playerEntity = this.getPlayer(shooter, (ServerWorld)world);
        NonNullList list = playerEntity.field_71071_by.field_70462_a;
        List<Object> handlers = new ArrayList();
        if (spellContext.castingTile instanceof IPlaceBlockResponder && spellContext.castingTile instanceof IPickupResponder) {
            handlers = ((IPlaceBlockResponder)spellContext.castingTile).getInventory();
        }
        if (shooter instanceof IPlaceBlockResponder && shooter instanceof IPickupResponder) {
            handlers = ((IPlaceBlockResponder)shooter).getInventory();
        }
        Block firstBlock = null;
        block0: for (BlockPos pos1 : posList) {
            BlockState state = world.func_180495_p(pos1);
            if (!this.canBlockBeHarvested(augments, world, pos1) || origState.func_177230_c() != state.func_177230_c() || world.func_180495_p(pos1).func_185904_a() != Material.field_151579_a && world.func_180495_p(pos1).func_177230_c() == BlockRegistry.INTANGIBLE_AIR) continue;
            if (this.isRealPlayer(shooter) && spellContext.castingTile == null) {
                firstBlock = this.swapFromInv((List<ItemStack>)list, origState, world, pos1, result, shooter, 9, firstBlock);
                continue;
            }
            if ((!(spellContext.castingTile instanceof IPlaceBlockResponder) || !(spellContext.castingTile instanceof IPickupResponder)) && (!(shooter instanceof IPlaceBlockResponder) || !(shooter instanceof IPickupResponder))) continue;
            boolean shouldBreak = false;
            for (IItemHandler iItemHandler : handlers) {
                for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    BlockItem item;
                    ItemStack stack = iItemHandler.getStackInSlot(slot);
                    if (!(stack.func_77973_b() instanceof BlockItem) || !(world instanceof ServerWorld) || (item = (BlockItem)stack.func_77973_b()).func_179223_d() == origState.func_177230_c()) continue;
                    if (firstBlock == null) {
                        firstBlock = item.func_179223_d();
                    } else if (item.func_179223_d() != firstBlock) continue;
                    if (!this.attemptPlace(stack, world, pos1, result, shooter)) continue;
                    shouldBreak = true;
                    break;
                }
                if (!shouldBreak) continue;
                continue block0;
            }
        }
    }

    public Block swapFromInv(List<ItemStack> inventory, BlockState origState, World world, BlockPos pos1, BlockRayTraceResult result, LivingEntity shooter, int slots, Block firstBlock) {
        for (int i = 0; i < slots; ++i) {
            BlockItem item;
            ItemStack stack = inventory.get(i);
            if (!(stack.func_77973_b() instanceof BlockItem) || !(world instanceof ServerWorld) || (item = (BlockItem)stack.func_77973_b()).func_179223_d() == origState.func_177230_c()) continue;
            if (firstBlock == null) {
                firstBlock = item.func_179223_d();
            } else if (item.func_179223_d() != firstBlock) continue;
            if (this.attemptPlace(stack, world, pos1, result, shooter)) break;
        }
        return firstBlock;
    }

    public boolean attemptPlace(ItemStack stack, World world, BlockPos pos1, BlockRayTraceResult result, LivingEntity shooter) {
        BlockItem item = (BlockItem)stack.func_77973_b();
        ItemStack tool = LootUtil.getDefaultFakeTool();
        tool.func_77966_a(Enchantments.field_185306_r, 1);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        BlockItemUseContext context = BlockItemUseContext.func_221536_a((BlockItemUseContext)new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, result)), (BlockPos)pos1.func_177972_a(result.func_216354_b().func_176734_d()), (Direction)result.func_216354_b());
        BlockState placeState = item.func_179223_d().func_196258_a(context);
        Block.func_220054_a((BlockState)world.func_180495_p(pos1), (World)world, (BlockPos)pos1, (TileEntity)world.func_175625_s(pos1), (Entity)shooter, (ItemStack)tool);
        BlockUtil.destroyBlockSafelyWithoutSound(world, pos1, false, shooter);
        if (placeState != null) {
            item.func_195942_a(context);
            return true;
        }
        return false;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentPierce.INSTANCE, AugmentAOE.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on blocks, exchanges the blocks in the players hotbar for the blocks hit as if they were mined with silk touch. Can be augmented with AOE, and Amplify is required for swapping blocks of higher hardness. When used on entities, the locations of the caster and the entity hit are swapped.";
    }

    @Override
    public Item getCraftingReagent() {
        return ArsNouveauAPI.getInstance().getGlyphItem("extract");
    }

    @Override
    public int getManaCost() {
        return 50;
    }
}

