/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EffectFangs
extends AbstractEffect {
    public static EffectFangs INSTANCE = new EffectFangs();

    private EffectFangs() {
        super("fangs", "Fangs");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, augments, spellContext);
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (shooter == null && spellContext.castingTile != null) {
            shooter = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
            BlockPos pos = spellContext.castingTile.func_174877_v();
            shooter.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        if (shooter == null) {
            return;
        }
        Vector3d vec = rayTraceResult.func_216347_e();
        double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * (double)this.getAmplificationBonus(augments);
        double targetX = vec.field_72450_a;
        double targetY = vec.field_72448_b;
        double targetZ = vec.field_72449_c;
        double d0 = Math.min(targetY, shooter.func_226278_cu_());
        double d1 = Math.max(targetY, shooter.func_226278_cu_()) + 1.0;
        float f = (float)MathHelper.func_181159_b((double)(targetZ - shooter.func_226281_cx_()), (double)(targetX - shooter.func_226277_ct_()));
        if (rayTraceResult instanceof EntityRayTraceResult && shooter.equals((Object)((EntityRayTraceResult)rayTraceResult).func_216348_a())) {
            int j;
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                j = (i + this.getDurationModifier(augments)) / (1 + EffectFangs.getBuffCount(augments, AugmentAccelerate.class));
                this.spawnFangs(world, shooter.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 1.5, shooter.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, j, shooter, (float)damage);
            }
            for (int k = 0; k < 8; ++k) {
                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                j = (k + this.getDurationModifier(augments)) / (1 + EffectFangs.getBuffCount(augments, AugmentAccelerate.class));
                this.spawnFangs(world, shooter.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.5, shooter.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, j, shooter, (float)damage);
            }
            return;
        }
        for (int l = 0; l < 16; ++l) {
            double d2 = 1.25 * (double)(l + 1);
            int j = (l + this.getDurationModifier(augments)) / (1 + EffectFangs.getBuffCount(augments, AugmentAccelerate.class));
            this.spawnFangs(world, shooter.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, shooter.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j, shooter, (float)damage);
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 3.0);
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.nonAirAnythingSuccess(rayTraceResult, world);
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    private void spawnFangs(World world, double xAngle, double zAngle, double yStart, double yEnd, float rotationYaw, int tickDelay, LivingEntity caster, float damage) {
        BlockPos blockpos = new BlockPos(xAngle, yEnd, zAngle);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)world, blockpos1, Direction.UP)) continue;
            if (!world.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = world.func_180495_p(blockpos)).func_196952_d((IBlockReader)world, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)yStart) - 1);
        if (flag) {
            world.func_217376_c((Entity)new EntityEvokerFangs(world, xAngle, (double)blockpos.func_177956_o() + d0, zAngle, rotationYaw, tickDelay, caster, damage));
        }
    }

    @Override
    public int getManaCost() {
        return 35;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_179562_cC;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAccelerate.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Summons Evoker Fangs in the direction where the spell was targeted.";
    }
}

