/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectFlare
extends AbstractEffect {
    public static EffectFlare INSTANCE = new EffectFlare();

    private EffectFlare() {
        super("flare", "Flare");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            Vector3d vec = this.safelyGetHitPos(rayTraceResult);
            float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * (double)this.getAmplificationBonus(augments));
            int range = 3 + EffectFlare.getBuffCount(augments, AugmentAOE.class);
            int fireSec = 5 + (Integer)this.EXTEND_TIME.get() * this.getDurationModifier(augments);
            if (livingEntity.func_70027_ad()) {
                this.dealDamage(world, shooter, damage, augments, (Entity)livingEntity, this.buildDamageSource(world, shooter).func_76361_j().func_76348_h());
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197631_x, vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, 50, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
                for (Entity e : world.func_72839_b((Entity)shooter, new AxisAlignedBB(livingEntity.func_233580_cy_().func_177964_d(range).func_177965_g(range).func_177981_b(range), livingEntity.func_233580_cy_().func_177970_e(range).func_177985_f(range).func_177979_c(range)))) {
                    if (e.equals((Object)livingEntity) || !(e instanceof LivingEntity)) continue;
                    this.dealDamage(world, shooter, damage, augments, e, this.buildDamageSource(world, shooter).func_76361_j().func_76348_h());
                    e.func_70015_d(fireSec);
                    vec = e.func_213303_ch();
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197631_x, vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, 50, ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), ParticleUtil.inRange(-0.1, 0.1), 0.3);
                }
            }
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 3.0);
        this.addExtendTimeConfig(builder, 1);
    }

    @Override
    public int getManaCost() {
        return 40;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on entities that are on fire, Flare causes a burst of damage and will spread fire and deal damage to other nearby entities. Does significantly more damage than Harm. Can be augmented with Extend Time, Amplify, and AOE.";
    }

    @Override
    public Item getCraftingReagent() {
        return ArsNouveauAPI.getInstance().getGlyphItem(EffectIgnite.INSTANCE);
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }
}

