/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectFreeze
extends AbstractEffect {
    public static EffectFreeze INSTANCE = new EffectFreeze();

    private EffectFreeze() {
        super("freeze", "Freeze");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, augments, spellContext);
        BlockPos pos = rayTraceResult.func_216350_a();
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, EffectFreeze.getBuffCount(augments, AugmentAOE.class))) {
            this.extinguishOrFreeze(world, p);
            for (Direction d : Direction.values()) {
                this.extinguishOrFreeze(world, p.func_177972_a(d));
            }
        }
    }

    public void extinguishOrFreeze(World world, BlockPos p) {
        BlockState state = world.func_180495_p(p.func_177984_a());
        FluidState fluidState = world.func_204610_c(p.func_177984_a());
        if (fluidState.func_206886_c() == Fluids.field_204546_a && state.func_177230_c() instanceof FlowingFluidBlock) {
            world.func_175656_a(p.func_177984_a(), Blocks.field_150432_aD.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151581_o) {
            world.func_175655_b(p.func_177984_a(), false);
        }
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, augments, spellContext);
        if (!(rayTraceResult.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        this.applyConfigPotion((LivingEntity)rayTraceResult.func_216348_a(), Effects.field_76421_d, augments);
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 10);
        this.addExtendTimeConfig(builder, 5);
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.nonAirAnythingSuccess(rayTraceResult, world);
    }

    @Override
    public int getManaCost() {
        return 15;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221772_cv;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        HashSet<AbstractAugment> augments = new HashSet<AbstractAugment>(this.POTION_AUGMENTS);
        augments.add(AugmentAOE.INSTANCE);
        return augments;
    }

    @Override
    public String getBookDescription() {
        return "Freezes water in a small area or slows a target for a short time. Can be augmented with AOE, Extend Time, or Amplify.";
    }
}

