/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectHeal
extends AbstractEffect {
    public static EffectHeal INSTANCE = new EffectHeal();

    private EffectHeal() {
        super("heal", "Heal");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (entity.field_70128_L || entity.func_110143_aJ() <= 0.0f) {
                return;
            }
            float healVal = (float)((Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * (double)EffectHeal.getBuffCount(augments, AugmentAmplify.class));
            if (EffectHeal.getBuffCount(augments, AugmentExtendTime.class) > 0) {
                this.applyPotionWithCap(entity, Effects.field_76428_l, augments, 5, 5, 5);
            } else if (entity.func_70662_br()) {
                this.dealDamage(world, shooter, healVal, augments, (Entity)entity, this.buildDamageSource(world, shooter).func_82726_p());
            } else {
                entity.func_70691_i(healVal);
            }
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericDouble(builder, 3.0, "Base heal amount", "base_heal");
        this.addAmpConfig(builder, 3.0);
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.livingEntityHitSuccess(rayTraceResult);
    }

    @Override
    public int getManaCost() {
        return 100;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151060_bw;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Heals a small amount of health for the target. When used with Extend Time, the Regeneration buff is applied instead, up to level 5. When used on Undead, the spell will deal an equal amount of magic damage.";
    }
}

