/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IInteractResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EffectInteract
extends AbstractEffect {
    public static EffectInteract INSTANCE = new EffectInteract();

    private EffectInteract() {
        super("interact", "Interact");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        Entity e;
        if (rayTraceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            BlockPos blockPos = blockRayTraceResult.func_216350_a();
            BlockState blockState = world.func_180495_p(blockPos);
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerWorld)world), world, blockPos)) {
                return;
            }
            if (this.isRealPlayer(shooter)) {
                blockState.func_227031_a_(world, (PlayerEntity)shooter, Hand.MAIN_HAND, (BlockRayTraceResult)rayTraceResult);
            } else if (world instanceof ServerWorld) {
                ANFakePlayer player = new ANFakePlayer((ServerWorld)world);
                ItemStack stack = shooter instanceof IInteractResponder ? ((IInteractResponder)shooter).getHeldItem().func_77946_l() : ItemStack.field_190927_a;
                player.func_184611_a(Hand.MAIN_HAND, stack);
                blockState.func_227031_a_(world, (PlayerEntity)player, Hand.MAIN_HAND, (BlockRayTraceResult)rayTraceResult);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (player.func_184614_ca().func_77973_b() instanceof ShearsItem) {
                    items.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
                    items.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
                    items.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
                    this.returnItems(rayTraceResult, world, shooter, augments, spellContext, items);
                }
            }
        }
        if (rayTraceResult instanceof EntityRayTraceResult && (e = ((EntityRayTraceResult)rayTraceResult).func_216348_a()) instanceof AnimalEntity) {
            if (shooter instanceof PlayerEntity) {
                ((AnimalEntity)e).func_230254_b_((PlayerEntity)shooter, Hand.MAIN_HAND);
            } else if (shooter instanceof IInteractResponder) {
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
                fakePlayer.field_71071_by.func_174888_l();
                fakePlayer.func_70107_b(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
                ItemStack stack = ((IInteractResponder)shooter).getHeldItem().func_77946_l();
                fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
                e.func_184230_a((PlayerEntity)fakePlayer, Hand.MAIN_HAND);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (e instanceof IForgeShearable && fakePlayer.func_184614_ca().func_77973_b() instanceof ShearsItem && ((IForgeShearable)e).isShearable(fakePlayer.func_184614_ca(), world, e.func_233580_cy_())) {
                    items.addAll(((IForgeShearable)e).onSheared((PlayerEntity)fakePlayer, fakePlayer.func_184614_ca(), world, e.func_233580_cy_(), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakePlayer.func_184614_ca())));
                }
                items.addAll((Collection<ItemStack>)fakePlayer.field_71071_by.field_70462_a);
                items.addAll((Collection<ItemStack>)fakePlayer.field_71071_by.field_70460_b);
                items.addAll((Collection<ItemStack>)fakePlayer.field_71071_by.field_184439_c);
                this.returnItems(rayTraceResult, world, shooter, augments, spellContext, items);
            }
        }
    }

    public void returnItems(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext, List<ItemStack> items) {
        for (ItemStack i : items) {
            if (shooter instanceof IPickupResponder) {
                ItemStack leftOver = ((IPickupResponder)shooter).onPickup(i);
                if (leftOver.func_190926_b()) continue;
                world.func_217376_c((Entity)new ItemEntity(world, rayTraceResult.func_216347_e().field_72450_a, rayTraceResult.func_216347_e().field_72448_b, rayTraceResult.func_216347_e().field_72449_c, leftOver));
                continue;
            }
            world.func_217376_c((Entity)new ItemEntity(world, rayTraceResult.func_216347_e().field_72450_a, rayTraceResult.func_216347_e().field_72448_b, rayTraceResult.func_216347_e().field_72449_c, i));
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.nonAirAnythingSuccess(rayTraceResult, world);
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221746_ci;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Interacts with blocks or entities as it were a player. Useful for reaching levers, chests, or animals.";
    }

    @Override
    public int getManaCost() {
        return 10;
    }
}

