/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectKnockback
extends AbstractEffect {
    public static EffectKnockback INSTANCE = new EffectKnockback();

    private EffectKnockback() {
        super("gust", "Knockback");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            float strength = (float)((Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * (double)this.getAmplificationBonus(augments));
            this.knockback(target, shooter, strength);
            target.field_70133_I = true;
        }
    }

    public void knockback(LivingEntity target, LivingEntity entityKnockingAway, float strength) {
        target.func_233627_a_(strength, (double)MathHelper.func_76126_a((float)(entityKnockingAway.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(entityKnockingAway.field_70177_z * ((float)Math.PI / 180)))));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericDouble(builder, 1.5, "Base knockback value", "base_value");
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.livingEntityHitSuccess(rayTraceResult);
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    public int getManaCost() {
        return 15;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221602_aD;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Knocks a target away a short distance from the caster";
    }
}

