/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectPlaceBlock
extends AbstractEffect {
    public static EffectPlaceBlock INSTANCE = new EffectPlaceBlock();

    private EffectPlaceBlock() {
        super("place_block", "Place Block");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        int aoeBuff = EffectPlaceBlock.getBuffCount(augments, AugmentAOE.class);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, aoeBuff, EffectPlaceBlock.getBuffCount(augments, AugmentPierce.class));
        BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
        for (BlockPos pos1 : posList) {
            BlockRayTraceResult resolveResult;
            BlockItem item;
            ActionResultType resultType;
            ItemStack stack;
            BlockItem item2;
            ItemStack stack2;
            BlockPos hitPos;
            BlockPos blockPos = hitPos = result.func_216353_d() ? pos1 : pos1.func_177972_a(result.func_216354_b());
            if (spellContext.castingTile instanceof IPlaceBlockResponder) {
                stack2 = ((IPlaceBlockResponder)spellContext.castingTile).onPlaceBlock();
                if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof BlockItem)) {
                    return;
                }
                item2 = (BlockItem)stack2.func_77973_b();
                ANFakePlayer fakePlayer = new ANFakePlayer((ServerWorld)world);
                fakePlayer.func_184611_a(Hand.MAIN_HAND, stack2);
                boolean isTouch = spellContext.getSpell().recipe.get(0) instanceof MethodTouch;
                BlockState blockTargetted = isTouch ? world.func_180495_p(hitPos.func_177972_a(result.func_216354_b().func_176734_d())) : world.func_180495_p(hitPos.func_177972_a(result.func_216354_b()));
                if (blockTargetted.func_185904_a() != Material.field_151579_a) continue;
                Direction direction = isTouch ? result.func_216354_b().func_176734_d() : result.func_216354_b();
                BlockItemUseContext context = BlockItemUseContext.func_221536_a((BlockItemUseContext)new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, result)), (BlockPos)hitPos.func_177972_a(direction), (Direction)direction);
                item2.func_195942_a(context);
                continue;
            }
            if (shooter instanceof IPlaceBlockResponder) {
                stack2 = ((IPlaceBlockResponder)shooter).onPlaceBlock();
                if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof BlockItem)) {
                    return;
                }
                item2 = (BlockItem)stack2.func_77973_b();
                if (world.func_180495_p(hitPos).func_185904_a() != Material.field_151579_a) {
                    result = new BlockRayTraceResult(result.func_216347_e().func_72441_c(0.0, 1.0, 0.0), Direction.UP, result.func_216350_a(), false);
                }
                EffectPlaceBlock.attemptPlace(world, stack2, item2, result);
                continue;
            }
            if (!(shooter instanceof PlayerEntity)) continue;
            PlayerEntity playerEntity = (PlayerEntity)shooter;
            NonNullList list = playerEntity.field_71071_by.field_70462_a;
            if (world.func_180495_p(hitPos).func_185904_a() != Material.field_151579_a) continue;
            for (int i = 0; !(i >= 9 || (stack = (ItemStack)list.get(i)).func_77973_b() instanceof BlockItem && world instanceof ServerWorld && ActionResultType.FAIL != (resultType = EffectPlaceBlock.attemptPlace(world, stack, item = (BlockItem)stack.func_77973_b(), resolveResult = new BlockRayTraceResult(new Vector3d((double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p()), result.func_216354_b(), hitPos, false)))); ++i) {
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.nonAirBlockSuccess(rayTraceResult, world);
    }

    public static ActionResultType attemptPlace(World world, ItemStack stack, BlockItem item, BlockRayTraceResult result) {
        ANFakePlayer fakePlayer = new ANFakePlayer((ServerWorld)world);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        BlockItemUseContext context = BlockItemUseContext.func_221536_a((BlockItemUseContext)new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, result)), (BlockPos)result.func_216350_a(), (Direction)result.func_216354_b());
        return item.func_195942_a(context);
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221656_ap;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Places blocks from the casters inventory. If a player is casting this, this spell will place blocks from the hot bar first.";
    }
}

