/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectSmelt
extends AbstractEffect {
    public static EffectSmelt INSTANCE = new EffectSmelt();

    private EffectSmelt() {
        super("smelt", "Smelt");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        int aoeBuff = EffectSmelt.getBuffCount(augments, AugmentAOE.class);
        int pierceBuff = EffectSmelt.getBuffCount(augments, AugmentPierce.class);
        int maxItemSmelt = 3 + 4 * aoeBuff + 4 * pierceBuff;
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, aoeBuff, pierceBuff);
        List itemEntities = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_186662_g((double)aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt);
        for (BlockPos pos : posList) {
            if (!this.canBlockBeHarvested(augments, world, pos)) continue;
            this.smeltBlock(world, pos, shooter);
        }
    }

    public void smeltBlock(World world, BlockPos pos, LivingEntity shooter) {
        ItemStack itemstack;
        BlockState state = world.func_180495_p(pos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerWorld)world), world, pos)) {
            return;
        }
        Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1)}), world);
        if (optional.isPresent() && !(itemstack = ((FurnaceRecipe)optional.get()).func_77571_b()).func_190926_b()) {
            if (itemstack.func_77973_b() instanceof BlockItem) {
                world.func_175656_a(pos, ((BlockItem)itemstack.func_77973_b()).func_179223_d().func_176223_P());
            } else {
                BlockUtil.destroyBlockSafely(world, pos, false, shooter);
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack.func_77946_l()));
                BlockUtil.safelyUpdateState(world, pos);
            }
        }
    }

    public void smeltItems(World world, List<ItemEntity> itemEntities, int maxItemSmelt) {
        int numSmelted = 0;
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack result;
            if (numSmelted > maxItemSmelt) break;
            Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{itemEntity.func_92059_d()}), world);
            if (!optional.isPresent() || (result = ((FurnaceRecipe)optional.get()).func_77571_b().func_77946_l()).func_190926_b()) continue;
            while (numSmelted < maxItemSmelt && !itemEntity.func_92059_d().func_190926_b()) {
                itemEntity.func_92059_d().func_190918_g(1);
                world.func_217376_c((Entity)new ItemEntity(world, itemEntity.func_226277_ct_(), itemEntity.func_226278_cu_(), itemEntity.func_226281_cx_(), result.func_77946_l()));
                ++numSmelted;
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof BlockRayTraceResult;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Smelts blocks and items in the world. AOE will increase the number of items and radius of blocks that can be smelted at once, while Amplify will allow Smelt to work on blocks of higher hardness.";
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    public int getManaCost() {
        return 100;
    }

    @Override
    public Item getCraftingReagent() {
        return Items.field_222102_pI;
    }
}

