/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectSummonDecoy
extends AbstractEffect {
    public static EffectSummonDecoy INSTANCE = new EffectSummonDecoy();

    private EffectSummonDecoy() {
        super("summon_decoy", "Summon Decoy");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        super.onResolve(rayTraceResult, world, shooter, augments, spellContext);
        if (shooter != null) {
            Vector3d pos = this.safelyGetHitPos(rayTraceResult);
            EntityDummy dummy = new EntityDummy(world);
            dummy.ticksLeft = 20 * ((Integer)this.GENERIC_INT.get() + this.getDurationModifier(augments) * (Integer)this.EXTEND_TIME.get());
            dummy.func_70107_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c);
            dummy.setOwnerID(shooter.func_110124_au());
            this.summonLivingEntity(rayTraceResult, world, shooter, augments, spellContext, dummy);
            world.func_217357_a(MobEntity.class, dummy.func_174813_aQ().func_72314_b(20.0, 10.0, 20.0)).forEach(l -> l.func_70624_b((LivingEntity)dummy));
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addExtendTimeConfig(builder, 15);
        this.addGenericInt(builder, 30, "Base duration in seconds", "duration");
    }

    @Override
    public int getManaCost() {
        return 200;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.SUMMON_AUGMENTS;
    }

    @Override
    public String getBookDescription() {
        return "Summons a decoy of yourself. Upon summoning, the decoy will attract any nearby mobs to attack it. Does not apply summoning sickness.";
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_179565_cj;
    }
}

