/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectSummonVex
extends AbstractEffect {
    public static EffectSummonVex INSTANCE = new EffectSummonVex();

    private EffectSummonVex() {
        super("summon_vex", "Summon Vex");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (this.isRealPlayer(shooter) && shooter != null && shooter.func_70660_b((Effect)ModPotions.SUMMONING_SICKNESS) == null) {
            this.summonEntities(shooter, world, augments, rayTraceResult.func_216348_a().func_233580_cy_());
        }
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (this.isRealPlayer(shooter) && shooter != null && shooter.func_70660_b((Effect)ModPotions.SUMMONING_SICKNESS) == null) {
            this.summonEntities(shooter, world, augments, rayTraceResult.func_216350_a());
        }
    }

    public void summonEntities(LivingEntity shooter, World world, List<AbstractAugment> augments, BlockPos pos) {
        int ticks = 20 * ((Integer)this.GENERIC_INT.get() + (Integer)this.EXTEND_TIME.get() * this.getDurationModifier(augments));
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos = pos.func_177982_a(-2 + shooter.func_70681_au().nextInt(5), 2, -2 + shooter.func_70681_au().nextInt(5));
            EntityAllyVex vexentity = new EntityAllyVex(world, shooter);
            vexentity.func_174828_a(blockpos, 0.0f, 0.0f);
            vexentity.func_213386_a((IServerWorld)world, world.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, null, null);
            vexentity.setOwner(shooter);
            vexentity.func_190651_g(blockpos);
            vexentity.func_190653_a(ticks);
            world.func_217376_c((Entity)vexentity);
        }
        shooter.func_195064_c(new EffectInstance((Effect)ModPotions.SUMMONING_SICKNESS, ticks));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 15, "Base duration in seconds", "duration");
        this.addExtendTimeConfig(builder, 10);
    }

    @Override
    public int getManaCost() {
        return 75;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_190929_cY;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.SUMMON_AUGMENTS;
    }

    @Override
    public String getBookDescription() {
        return "Summons three Vex allies that will attack nearby hostile enemies. These Vex will last a short time until they begin to take damage, but time may be extended with the Extend Time augment.";
    }
}

