/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.block.tile.LightTile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.world.FeatureLib;
import com.hollingsworth.arsnouveau.common.world.feature.SingleBlockFeature;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.common.world.tree.SupplierBlockStateProvider;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.BlockStateMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class WorldEvent {
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> CASCADING_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SupplierBlockStateProvider("blue_archwood_log"), (BlockStateProvider)new SupplierBlockStateProvider("blue_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> BLAZING_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SupplierBlockStateProvider("red_archwood_log"), (BlockStateProvider)new SupplierBlockStateProvider("red_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> FLOURISHING_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SupplierBlockStateProvider("green_archwood_log"), (BlockStateProvider)new SupplierBlockStateProvider("green_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> VEXING_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_log"), (BlockStateProvider)new SupplierBlockStateProvider("purple_archwood_leaves"), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> MAGIC_TREE_CONFIG2 = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196623_P.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196574_ab.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new MagicTrunkPlacer(9, 1, 0), (AbstractFeatureSizeType)new TwoLayerFeature(2, 0, 2)).func_236700_a_().func_225568_b_());
    public static final StructureProcessorList ARCHWOOD_PLAINS = new StructureProcessorList((List)ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()), (Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150341_Y, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196777_fo, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196617_K, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196662_n, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150476_ad, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_203204_R, 0.02f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150459_bM.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_185773_cZ.func_176223_P())}))));
    public static Biome archwoodForest = (Biome)BiomeMaker.func_244252_r().setRegistryName("ars_nouveau", "archwood_forest");
    public static Biome blazingForest = (Biome)BiomeMaker.func_244252_r().setRegistryName("ars_nouveau", "blazing_archwood_forest");
    public static RegistryKey<Biome> archwoodKey = BiomeRegistry.access$000(archwoodForest);

    public static void registerFeatures() {
        BlockClusterFeatureConfig BERRY_BUSH_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.MANA_BERRY_BUSH.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i)).func_227317_b_().func_227322_d_();
        float treeChance = ((Double)Config.TREE_SPAWN_RATE.get()).floatValue();
        ConfiguredFeature CASCADE = CASCADING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, treeChance, 1)));
        ConfiguredFeature BLAZE = BLAZING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, treeChance, 1)));
        ConfiguredFeature VEX = VEXING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, treeChance, 1)));
        ConfiguredFeature FLOURISHING = FLOURISHING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, treeChance, 1)));
        ConfiguredFeature FLOURISHING_COMMON = FLOURISHING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(12, 0.01f, 1)));
        ConfiguredFeature CASCADE_COMMON = CASCADING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(12, 0.01f, 1)));
        ConfiguredFeature BLAZE_COMMON = BLAZING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(12, 0.01f, 1)));
        ConfiguredFeature VEX_COMMON = VEXING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(12, 0.01f, 1)));
        ConfiguredFeature BLAZE_SEMI = BLAZING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.01f, 1)));
        SingleBlockFeature LIGHTS = new SingleBlockFeature(BlockStateFeatureConfig.field_236455_a_){

            @Override
            public void onStatePlace(ISeedReader seed, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
                if (seed instanceof WorldGenRegion) {
                    WorldGenRegion world = (WorldGenRegion)seed;
                    Random random = world.func_201674_k();
                    if (world.func_175625_s(pos) instanceof LightTile) {
                        LightTile tile = (LightTile)world.func_175625_s(pos);
                        tile.red = Math.max(10, random.nextInt(255));
                        tile.green = Math.max(10, random.nextInt(255));
                        tile.blue = Math.max(10, random.nextInt(255));
                    }
                }
            }
        };
        ConfiguredFeature RANDOM_LIGHTS = LIGHTS.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(BlockRegistry.LIGHT_BLOCK.func_176223_P())).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.ARCANE_ORE.getRegistryName(), (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlockRegistry.ARCANE_ORE.func_176223_P(), 5)).func_242733_d(60)).func_242728_a()).func_242731_b(5));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.MANA_BERRY_BUSH.getRegistryName(), (Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BERRY_BUSH_PATCH_CONFIG).func_227228_a_(Features.Placements.field_244002_m));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.VEXING_SAPLING.getRegistryName(), (Object)VEX);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.BLAZING_SAPLING.getRegistryName(), (Object)BLAZE);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.CASCADING_SAPLING.getRegistryName(), (Object)CASCADE);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)BlockRegistry.FLOURISHING_SAPLING.getRegistryName(), (Object)FLOURISHING);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)FeatureLib.RANDOM_LIGHTS_LOC, (Object)RANDOM_LIGHTS);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)FeatureLib.BLAZE_COMMON_LOC, (Object)BLAZE_COMMON);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)FeatureLib.BLAZE_SEMI_LOC, (Object)BLAZE_SEMI);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)FeatureLib.ARCHWOOD_TREES, (Object)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)VEX_COMMON.func_227227_a_(0.15f), (Object)BLAZE_COMMON.func_227227_a_(0.15f), (Object)CASCADE_COMMON.func_227227_a_(0.15f), (Object)FLOURISHING_COMMON.func_227227_a_(0.15f)), VEXING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.0f, 0))))));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)FeatureLib.VANILLA_BIG_TREES, (Object)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243869_bO.func_227227_a_(0.5f), (Object)Features.field_243920_cc.func_227227_a_(0.2f), (Object)Features.field_243922_ce.func_227227_a_(0.2f), (Object)Features.field_243863_bI.func_227227_a_(0.1f)), VEXING_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.0f, 0))))));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)new ResourceLocation("ars_nouveau", "archwood_plains"), (Object)ARCHWOOD_PLAINS);
    }

    @SubscribeEvent
    public static void biomeLoad(BiomeLoadingEvent e) {
        List<Biome.Category> categories;
        if (e.getCategory() == Biome.Category.NETHER || e.getCategory() == Biome.Category.THEEND) {
            return;
        }
        if (((Boolean)Config.SPAWN_ORE.get()).booleanValue()) {
            e.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.ARCANE_ORE.getRegistryName()))).func_242508_a();
        }
        if ((categories = Arrays.asList(Biome.Category.FOREST, Biome.Category.EXTREME_HILLS, Biome.Category.JUNGLE, Biome.Category.PLAINS, Biome.Category.SWAMP, Biome.Category.SAVANNA)).contains(e.getCategory())) {
            e.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.ENTITY_CARBUNCLE_TYPE, ((Integer)Config.CARBUNCLE_WEIGHT.get()).intValue(), 1, 1));
            e.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ModEntities.ENTITY_SYLPH_TYPE, ((Integer)Config.SYLPH_WEIGHT.get()).intValue(), 1, 1));
        }
        if (!e.getCategory().equals((Object)Biome.Category.MUSHROOM)) {
            if (e.getClimate().field_242461_c <= 0.35f && (Integer)Config.WGUARDIAN_WEIGHT.get() > 0) {
                e.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.WILDEN_GUARDIAN, ((Integer)Config.WGUARDIAN_WEIGHT.get()).intValue(), 1, 1));
            }
            if ((Integer)Config.WSTALKER_WEIGHT.get() > 0) {
                e.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.WILDEN_STALKER, ((Integer)Config.WSTALKER_WEIGHT.get()).intValue(), 3, 3));
            }
            if ((Integer)Config.WHUNTER_WEIGHT.get() > 0) {
                e.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(ModEntities.WILDEN_HUNTER, ((Integer)Config.WHUNTER_WEIGHT.get()).intValue(), 1, 1));
            }
        }
        if ((e.getCategory().equals((Object)Biome.Category.TAIGA) || e.getName().equals((Object)new ResourceLocation("ars_nouveau", "archwood_forest"))) && ((Boolean)Config.SPAWN_BERRIES.get()).booleanValue()) {
            e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.MANA_BERRY_BUSH.getRegistryName()))).func_242508_a();
        }
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.VEXING_SAPLING.getRegistryName()))).func_242508_a();
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.CASCADING_SAPLING.getRegistryName()))).func_242508_a();
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.BLAZING_SAPLING.getRegistryName()))).func_242508_a();
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(BlockRegistry.FLOURISHING_SAPLING.getRegistryName()))).func_242508_a();
        if (e.getName().equals((Object)archwoodForest.getRegistryName())) {
            WorldEvent.addArchwoodForestFeatures(e);
        }
        if (e.getName().equals((Object)blazingForest.getRegistryName())) {
            WorldEvent.addBlazingForestFeatures(e);
        }
    }

    public static void addBlazingForestFeatures(BiomeLoadingEvent e) {
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(FeatureLib.BLAZE_SEMI_LOC))).func_242508_a();
    }

    public static void addArchwoodForestFeatures(BiomeLoadingEvent e) {
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(FeatureLib.ARCHWOOD_TREES))).func_242508_a();
        e.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(FeatureLib.VANILLA_BIG_TREES))).func_242508_a();
        e.getGeneration().func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, (ConfiguredFeature)Objects.requireNonNull(WorldGenRegistries.field_243653_e.func_82594_a(FeatureLib.RANDOM_LIGHTS_LOC))).func_242508_a();
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.ServerTickEvent e) {
        if (e.side != LogicalSide.SERVER || e.phase != TickEvent.Phase.END) {
            return;
        }
        EventQueue.getInstance().tick();
    }

    @ObjectHolder(value="ars_nouveau")
    @Mod.EventBusSubscriber(modid="ars_nouveau", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class BiomeRegistry {
        @SubscribeEvent
        public static void biomeRegistry(RegistryEvent.Register<Biome> biomeRegistryEvent) {
            biomeRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{archwoodForest});
            BiomeDictionary.addTypes(archwoodKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
        }

        private static RegistryKey<Biome> k(Biome b) {
            return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(b.getRegistryName()));
        }

        static /* synthetic */ RegistryKey access$000(Biome x0) {
            return BiomeRegistry.k(x0);
        }
    }
}

