/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeTextureConfig
implements IResourceReloadListener<Map<ResourceLocation, String>> {
    private static final int VERSION = 2;
    private static final JsonParser PARSER = new JsonParser();
    private final BiomeTextureMap biomeTextureMap;
    private final TextureSetMap textureSetMap;

    public BiomeTextureConfig(BiomeTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.biomeTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, String>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, String> map = new HashMap<ResourceLocation, String>();
            try {
                for (IResource resource : manager.func_199004_b(new ResourceLocation("antiqueatlas:biome_textures.json"))) {
                    try {
                        InputStream stream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonElement element = PARSER.parse((Reader)reader);
                                if (element.isJsonObject()) {
                                    JsonObject obj = element.getAsJsonObject();
                                    if (!obj.has("version")) {
                                        Log.warn("Invalid biome texture file found!", new Object[0]);
                                        continue;
                                    }
                                    if (obj.get("version").getAsInt() < 2) {
                                        Log.warn("Outdated biome texture file version: " + obj.get("version").getAsInt(), new Object[0]);
                                        continue;
                                    }
                                    for (Map.Entry entry : obj.get("data").getAsJsonObject().entrySet()) {
                                        map.put(AntiqueAtlasMod.id((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                                    }
                                    continue;
                                }
                                Log.warn("Invalid biome texture file found!", new Object[0]);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        Log.warn(e, "Failed to read biome texture file!", new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read biome textures!", new Object[0]);
            }
            return map;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, String> biomeTexMap, IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : biomeTexMap.entrySet()) {
                Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_82594_a((ResourceLocation)entry.getKey());
                if (biome == null) {
                    Log.warn("Unknown biome in texture map: %s", entry.getKey());
                    continue;
                }
                String name = (String)entry.getValue();
                if (this.textureSetMap.isRegistered(name)) {
                    this.biomeTextureMap.setTexture(biome, this.textureSetMap.getByName(AntiqueAtlasMod.id(name)));
                    Log.info("Registered texture set %s for biome %s", name, entry.getKey());
                    continue;
                }
                Log.warn("Unknown texture set %s for biome %s", name, entry.getKey());
            }
        });
    }
}

