/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.Textures;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class TextureSet
implements Comparable<TextureSet> {
    public static final TextureSet TEST = new TextureSet(false, new ResourceLocation("test"), Textures.TILE_TEST, Textures.TILE_TEST);
    public static final TextureSet ICE = TextureSet.standard("ICE", Textures.TILE_ICE_NOBORDER);
    public static final TextureSet DESERT = TextureSet.standard("DESERT", Textures.TILE_SAND, Textures.TILE_SAND, Textures.TILE_SAND2, Textures.TILE_SAND2, Textures.TILE_SAND3, Textures.TILE_SAND3, Textures.TILE_SAND_BUSHES, Textures.TILE_SAND_BUSHES, Textures.TILE_CACTI);
    public static final TextureSet HILLS = TextureSet.standard("HILLS", Textures.TILE_HILLS);
    public static final TextureSet DESERT_HILLS = TextureSet.standard("DESERT_HILLS", Textures.TILE_HILLS, Textures.TILE_HILLS, Textures.TILE_HILLS, Textures.TILE_HILLS_BUSHES, Textures.TILE_HILLS_CACTI);
    public static final TextureSet PLAINS = TextureSet.standard("PLAINS", Textures.TILE_GRASS, Textures.TILE_GRASS2, Textures.TILE_GRASS3, Textures.TILE_GRASS4);
    public static final TextureSet SUNFLOWERS = TextureSet.standard("SUNFLOWERS", Textures.TILE_SUNFLOWERS, Textures.TILE_SUNFLOWERS2, Textures.TILE_GRASS3, Textures.TILE_GRASS4);
    public static final TextureSet ICE_SPIKES = TextureSet.standard("ICE_SPIKES", Textures.TILE_ICE_SPIKES, Textures.TILE_ICE_SPIKES2);
    public static final TextureSet SNOW_PINES = TextureSet.standard("SNOW_PINES", Textures.TILE_SNOW_PINES, Textures.TILE_SNOW_PINES2, Textures.TILE_SNOW_PINES3);
    public static final TextureSet SNOW_PINES_HILLS = TextureSet.standard("SNOW_PINES_HILLS", Textures.TILE_SNOW_PINES_HILLS, Textures.TILE_SNOW_PINES_HILLS2, Textures.TILE_SNOW_PINES_HILLS3);
    public static final TextureSet SNOW_HILLS = TextureSet.standard("SNOW_HILLS", Textures.TILE_SNOW_HILLS, Textures.TILE_SNOW_HILLS2);
    public static final TextureSet SNOW = TextureSet.standard("SNOW", Textures.TILE_SNOW, Textures.TILE_SNOW, Textures.TILE_SNOW, Textures.TILE_SNOW, Textures.TILE_SNOW, Textures.TILE_SNOW1, Textures.TILE_SNOW1, Textures.TILE_SNOW1, Textures.TILE_SNOW2, Textures.TILE_SNOW2, Textures.TILE_SNOW2, Textures.TILE_SNOW3, Textures.TILE_SNOW4, Textures.TILE_SNOW5, Textures.TILE_SNOW6);
    public static final TextureSet MOUNTAINS_NAKED = TextureSet.standard("MOUNTAINS_NAKED", Textures.TILE_MOUNTAINS, Textures.TILE_MOUNTAINS2);
    public static final TextureSet MOUNTAINS = TextureSet.standard("MOUNTAINS", Textures.TILE_MOUNTAINS, Textures.TILE_MOUNTAINS, Textures.TILE_MOUNTAINS2, Textures.TILE_MOUNTAINS2, Textures.TILE_MOUNTAINS3, Textures.TILE_MOUNTAINS4);
    public static final TextureSet MOUNTAINS_SNOW_CAPS = TextureSet.standard("MOUNTAINS_SNOW_CAPS", Textures.TILE_MOUNTAINS, Textures.TILE_SNOW_CAPS);
    public static final TextureSet MOUNTAINS_ALL = TextureSet.standard("MOUNTAINS_ALL", Textures.TILE_SNOW_CAPS, Textures.TILE_SNOW_CAPS, Textures.TILE_MOUNTAINS, Textures.TILE_MOUNTAINS2, Textures.TILE_MOUNTAINS3, Textures.TILE_MOUNTAINS4);
    public static final TextureSet FOREST = TextureSet.standard("FOREST", Textures.TILE_FOREST, Textures.TILE_FOREST2, Textures.TILE_FOREST3);
    public static final TextureSet FOREST_HILLS = TextureSet.standard("FOREST_HILLS", Textures.TILE_FOREST_HILLS, Textures.TILE_FOREST_HILLS2, Textures.TILE_FOREST_HILLS3);
    public static final TextureSet FOREST_FLOWERS = TextureSet.standard("FOREST_FLOWERS", Textures.TILE_FOREST_FLOWERS, Textures.TILE_FOREST_FLOWERS2, Textures.TILE_FOREST_FLOWERS3);
    public static final TextureSet SPARSE_FOREST = TextureSet.standard("SPARSE_FOREST", Textures.TILE_SPARSE_FOREST, Textures.TILE_SPARSE_FOREST2, Textures.TILE_SPARSE_FOREST3);
    public static final TextureSet SPARSE_FOREST_HILLS = TextureSet.standard("SPARSE_FOREST_HILLS", Textures.TILE_SPARSE_FOREST_HILLS, Textures.TILE_SPARSE_FOREST_HILLS2, Textures.TILE_SPARSE_FOREST_HILLS3);
    public static final TextureSet DENSE_FOREST = TextureSet.standard("DENSE_FOREST", Textures.TILE_DENSE_FOREST, Textures.TILE_DENSE_FOREST2);
    public static final TextureSet DENSE_FOREST_HILLS = TextureSet.standard("DENSE_FOREST_HILLS", Textures.TILE_DENSE_FOREST_HILLS, Textures.TILE_DENSE_FOREST_HILLS2);
    public static final TextureSet BIRCH = TextureSet.standard("BIRCH", Textures.TILE_BIRCH, Textures.TILE_BIRCH2);
    public static final TextureSet BIRCH_HILLS = TextureSet.standard("BIRCH_HILLS", Textures.TILE_BIRCH_HILLS, Textures.TILE_BIRCH_HILLS2);
    public static final TextureSet TALL_BIRCH = TextureSet.standard("TALL_BIRCH", Textures.TILE_TALL_BIRCH, Textures.TILE_TALL_BIRCH2);
    public static final TextureSet TALL_BIRCH_HILLS = TextureSet.standard("TALL_BIRCH_HILLS", Textures.TILE_TALL_BIRCH_HILLS, Textures.TILE_TALL_BIRCH_HILLS2);
    public static final TextureSet DENSE_BIRCH = TextureSet.standard("DENSE_BIRCH", Textures.TILE_DENSE_BIRCH);
    public static final TextureSet JUNGLE = TextureSet.standard("JUNGLE", Textures.TILE_JUNGLE, Textures.TILE_JUNGLE2);
    public static final TextureSet JUNGLE_HILLS = TextureSet.standard("JUNGLE_HILLS", Textures.TILE_JUNGLE_HILLS, Textures.TILE_JUNGLE_HILLS2);
    public static final TextureSet JUNGLE_CLIFFS = TextureSet.standard("JUNGLE_CLIFFS", Textures.TILE_JUNGLE_CLIFFS, Textures.TILE_JUNGLE_CLIFFS2, Textures.TILE_BUSHES_CLIFFS);
    public static final TextureSet JUNGLE_EDGE = TextureSet.standard("JUNGLE_EDGE", Textures.TILE_JUNGLE_EDGE, Textures.TILE_JUNGLE_EDGE2, Textures.TILE_JUNGLE_EDGE3, Textures.TILE_GRASS2, Textures.TILE_GRASS3, Textures.TILE_GRASS4);
    public static final TextureSet JUNGLE_EDGE_HILLS = TextureSet.standard("JUNGLE_EDGE_HILLS", Textures.TILE_JUNGLE_EDGE_HILLS, Textures.TILE_JUNGLE_EDGE_HILLS2, Textures.TILE_JUNGLE_EDGE_HILLS3, Textures.TILE_HILLS_GRASS, Textures.TILE_HILLS_GRASS);
    public static final TextureSet PINES = TextureSet.standard("PINES", Textures.TILE_PINES, Textures.TILE_PINES2, Textures.TILE_PINES3);
    public static final TextureSet PINES_HILLS = TextureSet.standard("PINES_HILLS", Textures.TILE_PINES_HILLS, Textures.TILE_PINES_HILLS2, Textures.TILE_PINES_HILLS3);
    public static final TextureSet MEGA_SPRUCE = TextureSet.standard("MEGA_SPRUCE", Textures.TILE_MEGA_SPRUCE, Textures.TILE_MEGA_SPRUCE2);
    public static final TextureSet MEGA_SPRUCE_HILLS = TextureSet.standard("MEGA_SPRUCE_HILLS", Textures.TILE_MEGA_SPRUCE_HILLS, Textures.TILE_MEGA_SPRUCE_HILLS2);
    public static final TextureSet MEGA_TAIGA = TextureSet.standard("MEGA_TAIGA", Textures.TILE_MEGA_TAIGA, Textures.TILE_MEGA_TAIGA2);
    public static final TextureSet MEGA_TAIGA_HILLS = TextureSet.standard("MEGA_TAIGA_HILLS", Textures.TILE_MEGA_TAIGA_HILLS, Textures.TILE_MEGA_TAIGA_HILLS2);
    public static final TextureSet SAVANNA = TextureSet.standard("SAVANNA", Textures.TILE_SAVANNA, Textures.TILE_SAVANNA2, Textures.TILE_SAVANNA3, Textures.TILE_GRASS, Textures.TILE_GRASS2, Textures.TILE_GRASS2, Textures.TILE_GRASS3, Textures.TILE_GRASS3, Textures.TILE_GRASS4, Textures.TILE_GRASS4);
    public static final TextureSet SAVANNA_PLATEAU = TextureSet.standard("SAVANNA_CLIFFS", Textures.TILE_SAVANNA_CLIFFS, Textures.TILE_SAVANNA_CLIFFS2, Textures.TILE_SAVANNA_CLIFFS3, Textures.TILE_CLIFFS);
    public static final TextureSet PLATEAU_SAVANNA = TextureSet.standard("PLATEAU_SAVANNA", Textures.TILE_PLATEAU_GRASS, Textures.TILE_PLATEAU_GRASS, Textures.TILE_PLATEAU_GRASS2, Textures.TILE_PLATEAU_GRASS2, Textures.TILE_PLATEAU_GRASS3, Textures.TILE_PLATEAU_GRASS3, Textures.TILE_PLATEAU_SAVANNA, Textures.TILE_PLATEAU_SAVANNA2, Textures.TILE_PLATEAU_SAVANNA3);
    public static final TextureSet PLATEAU_SAVANNA_M = TextureSet.standard("PLATEAU_SAVANNA_M", Textures.TILE_PLATEAU_GRASS, Textures.TILE_PLATEAU_GRASS2, Textures.TILE_PLATEAU_GRASS3, Textures.TILE_PLATEAU_SAVANNA2, Textures.TILE_PLATEAU_SAVANNA3, Textures.TILE_CLIFFS_CLOUDS, Textures.TILE_SAVANNA_CLIFFS_CLOUDS, Textures.TILE_SAVANNA_CLIFFS_CLOUDS2, Textures.TILE_SAVANNA_CLIFFS_CLOUDS3);
    public static final TextureSet MESA = TextureSet.standard("MESA", Textures.TILE_MESA, Textures.TILE_MESA2, Textures.TILE_MESA3, Textures.TILE_MESA4, Textures.TILE_SAND_BUSHES);
    public static final TextureSet BRYCE = TextureSet.standard("BRYCE", Textures.TILE_BRYCE, Textures.TILE_BRYCE2, Textures.TILE_BRYCE3, Textures.TILE_BRYCE4);
    public static final TextureSet PLATEAU_MESA = TextureSet.standard("PLATEAU_MESA", Textures.TILE_PLATEAU_MESA, Textures.TILE_PLATEAU_MESA2);
    public static final TextureSet PLATEAU_MESA_LOW = TextureSet.standard("PLATEAU_MESA_LOW", Textures.TILE_PLATEAU_MESA_LOW, Textures.TILE_PLATEAU_MESA_LOW2);
    public static final TextureSet PLATEAU_MESA_TREES = TextureSet.standard("PLATEAU_MESA_TREES", Textures.TILE_PLATEAU_MESA, Textures.TILE_PLATEAU_MESA2, Textures.TILE_PLATEAU_TREES);
    public static final TextureSet PLATEAU_MESA_TREES_LOW = TextureSet.standard("PLATEAU_MESA_TREES_LOW", Textures.TILE_PLATEAU_MESA_LOW, Textures.TILE_PLATEAU_MESA_LOW2, Textures.TILE_PLATEAU_TREES_LOW);
    public static final TextureSet SWAMP = TextureSet.standard("SWAMP", Textures.TILE_SWAMP, Textures.TILE_SWAMP, Textures.TILE_SWAMP, Textures.TILE_SWAMP2, Textures.TILE_SWAMP3, Textures.TILE_SWAMP4, Textures.TILE_SWAMP5, Textures.TILE_SWAMP6);
    public static final TextureSet SWAMP_HILLS = TextureSet.standard("SWAMP_HILLS", Textures.TILE_SWAMP_HILLS, Textures.TILE_SWAMP_HILLS2, Textures.TILE_SWAMP_HILLS3, Textures.TILE_SWAMP_HILLS4, Textures.TILE_SWAMP_HILLS5);
    public static final TextureSet WATER = TextureSet.standard("WATER", Textures.TILE_WATER, Textures.TILE_WATER2);
    public static final TextureSet LAVA = TextureSet.standard("LAVA", Textures.TILE_LAVA, Textures.TILE_LAVA2);
    public static final TextureSet SHORE = new TextureSetShore("SHORE", WATER, Textures.TILE_SHORE, Textures.TILE_SHORE2, Textures.TILE_SHORE3);
    public static final TextureSet ROCK_SHORE = new TextureSetShore("ROCK_SHORE", WATER, Textures.TILE_ROCK_SHORE).stitchesToNull();
    public static final TextureSet LAVA_SHORE = new TextureSetShore("LAVA_SHORE", LAVA, Textures.TILE_LAVA_SHORE, Textures.TILE_LAVA_SHORE2).stitchesToNull();
    public static final TextureSet SOUL_SAND_VALLEY = TextureSet.standard("DESERT", Textures.TILE_SAND, Textures.TILE_SAND2, Textures.TILE_SAND_BUSHES);
    public static final TextureSet END_VOID = TextureSet.standard("END_VOID", Textures.TILE_END_VOID);
    public static final TextureSet END_ISLAND = TextureSet.standard("END_ISLAND", Textures.TILE_END_ISLAND, Textures.TILE_END_ISLAND2);
    public static final TextureSet END_ISLAND_PLANTS = TextureSet.standard("END_ISLAND_PLANTS", Textures.TILE_END_ISLAND_PLANTS, Textures.TILE_END_ISLAND_PLANTS2);
    public static final TextureSet MUSHROOM = TextureSet.standard("MUSHROOM", Textures.TILE_MUSHROOM, Textures.TILE_MUSHROOM2);
    public static final TextureSet CAVE_WALLS = TextureSet.standard("CAVE_WALLS", Textures.TILE_CAVE_WALLS);
    public static final TextureSet RAVINE = TextureSet.standard("RAVINE", Textures.TILE_RAVINE);
    public static final TextureSet HOUSE = TextureSet.standard("HOUSE", Textures.TILE_HOUSE);
    public static final TextureSet FENCE = TextureSet.standard("FENCE", Textures.TILE_FENCE).stitchTo(HOUSE);
    public static final TextureSet LIBRARY = TextureSet.standard("LIBRARY", Textures.TILE_LIBRARY);
    public static final TextureSet SMITHY = TextureSet.standard("SMITHY", Textures.TILE_SMITHY);
    public static final TextureSet L_HOUSE = TextureSet.standard("L-HOUSE", Textures.TILE_L_HOUSE);
    public static final TextureSet FARMLAND_LARGE = TextureSet.standard("FARMLAND_LARGE", Textures.TILE_FARMLAND_LARGE);
    public static final TextureSet FARMLAND_SMALL = TextureSet.standard("FARMLAND_SMALL", Textures.TILE_FARMLAND_SMALL);
    public static final TextureSet VILLAGE_TORCH = TextureSet.standard("VILLAGE_TORCH", Textures.TILE_VILLAGE_TORCH);
    public static final TextureSet WELL = TextureSet.standard("WELL", Textures.TILE_WELL);
    public static final TextureSet HUT = TextureSet.standard("HUT", Textures.TILE_HUT);
    public static final TextureSet HOUSE_SMALL = TextureSet.standard("HOUSE_SMALL", Textures.TILE_HOUSE_SMALL);
    public static final TextureSet BUTCHERS_SHOP = TextureSet.standard("BUTCHERS_SHOP", Textures.TILE_BUTCHERS_SHOP);
    public static final TextureSet CHURCH = TextureSet.standard("CHURCH", Textures.TILE_CHURCH);
    public static final TextureSet NETHER_BRIDGE = TextureSet.standard("NETHER_BRIDGE", Textures.TILE_NETHER_BRIDGE);
    public static final TextureSet NETHER_BRIDGE_X = TextureSet.standard("NETHER_BRIDGE_X", Textures.TILE_NETHER_BRIDGE_X);
    public static final TextureSet NETHER_BRIDGE_Z = TextureSet.standard("NETHER_BRIDGE_Z", Textures.TILE_NETHER_BRIDGE_Z);
    public static final TextureSet NETHER_BRIDGE_END_X = TextureSet.standard("NETHER_BRIDGE_END_X", Textures.TILE_NETHER_BRIDGE_END_X);
    public static final TextureSet NETHER_BRIDGE_END_Z = TextureSet.standard("NETHER_BRIDGE_END_Z", Textures.TILE_NETHER_BRIDGE_END_Z);
    public static final TextureSet NETHER_BRIDGE_GATE = TextureSet.standard("NETHER_BRIDGE_GATE", Textures.TILE_NETHER_BRIDGE_GATE);
    public static final TextureSet NETHER_TOWER = TextureSet.standard("NETHER_TOWER", Textures.TILE_NETHER_TOWER);
    public static final TextureSet NETHER_WALL = TextureSet.standard("NETHER_WALL", Textures.TILE_NETHER_WALL);
    public static final TextureSet NETHER_HALL = TextureSet.standard("NETHER_HALL", Textures.TILE_NETHER_HALL);
    public static final TextureSet NETHER_FORT_STAIRS = TextureSet.standard("NETHER_FORT_STAIRS", Textures.TILE_NETHER_FORT_STAIRS);
    public static final TextureSet NETHER_THRONE = TextureSet.standard("NETHER_THRONE", Textures.TILE_NETHER_THRONE);
    public final ResourceLocation name;
    public final ResourceLocation[] textures;
    private final Set<TextureSet> stitchTo = new HashSet<TextureSet>();
    private final Set<TextureSet> stitchToHorizontal = new HashSet<TextureSet>();
    private final Set<TextureSet> stitchToVertical = new HashSet<TextureSet>();
    final boolean isStandard;
    private boolean stitchesToNull = false;
    private boolean anisotropicStitching = false;

    private static TextureSet standard(String name, ResourceLocation ... textures) {
        return new TextureSet(true, new ResourceLocation("antiqueatlas", name.toLowerCase(Locale.ROOT)), textures);
    }

    private TextureSet(boolean isStandard, ResourceLocation name, ResourceLocation ... textures) {
        this.isStandard = isStandard;
        this.name = name;
        this.textures = textures;
    }

    public TextureSet(ResourceLocation name, ResourceLocation ... textures) {
        this(false, name, textures);
    }

    TextureSet stitchesToNull() {
        this.stitchesToNull = true;
        return this;
    }

    private TextureSet stitchTo(TextureSet ... textureSets) {
        Collections.addAll(this.stitchTo, textureSets);
        return this;
    }

    public TextureSet stitchToMutual(TextureSet ... textureSets) {
        for (TextureSet textureSet : textureSets) {
            this.stitchTo.add(textureSet);
            textureSet.stitchTo.add(this);
        }
        return this;
    }

    private TextureSet stitchToHorizontal(TextureSet ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToHorizontal, textureSets);
        return this;
    }

    private TextureSet stitchToVertical(TextureSet ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToVertical, textureSets);
        return this;
    }

    public boolean shouldStitchTo(TextureSet toSet) {
        return toSet == this || this.stitchesToNull && toSet == null || this.stitchTo.contains(toSet);
    }

    public boolean shouldStitchToHorizontally(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToHorizontal.contains(toSet);
        }
        return this.stitchTo.contains(toSet);
    }

    public boolean shouldStitchToVertically(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToVertical.contains(toSet);
        }
        return this.stitchTo.contains(toSet);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TextureSet)) {
            return false;
        }
        TextureSet set = (TextureSet)obj;
        return this.name.equals((Object)set.name);
    }

    private static void stitchMutually(TextureSet ... sets) {
        for (TextureSet set1 : sets) {
            for (TextureSet set2 : sets) {
                if (set1 == set2) continue;
                set1.stitchTo(set2);
            }
        }
    }

    private static void stitchMutuallyHorizontally(TextureSet ... sets) {
        for (TextureSet set1 : sets) {
            for (TextureSet set2 : sets) {
                if (set1 == set2) continue;
                set1.stitchToHorizontal(set2);
            }
        }
    }

    private static void stitchMutuallyVertically(TextureSet ... sets) {
        for (TextureSet set1 : sets) {
            for (TextureSet set2 : sets) {
                if (set1 == set2) continue;
                set1.stitchToVertical(set2);
            }
        }
    }

    @Override
    public int compareTo(TextureSet textureSet) {
        return this.name.toString().compareTo(textureSet.name.toString());
    }

    static {
        TextureSet.stitchMutually(PLAINS, SUNFLOWERS);
        WATER.stitchTo(SHORE, ROCK_SHORE, SWAMP);
        LAVA.stitchTo(LAVA_SHORE);
        SWAMP.stitchTo(SWAMP_HILLS);
        SNOW.stitchTo(SNOW_PINES, SNOW_HILLS, ICE_SPIKES, SNOW_PINES_HILLS);
        SNOW_PINES.stitchTo(SNOW, SNOW_HILLS, ICE_SPIKES, SNOW_PINES_HILLS);
        TextureSet.stitchMutually(MOUNTAINS, MOUNTAINS_NAKED, MOUNTAINS_SNOW_CAPS, MOUNTAINS_ALL);
        DESERT.stitchTo(MESA, BRYCE);
        TextureSet.stitchMutually(PLATEAU_MESA, PLATEAU_MESA_TREES, PLATEAU_SAVANNA, PLATEAU_SAVANNA_M);
        TextureSet.stitchMutually(PLATEAU_MESA_LOW, PLATEAU_MESA_TREES_LOW);
        TextureSet.stitchMutually(END_ISLAND, END_ISLAND_PLANTS);
        LAVA.stitchTo(NETHER_BRIDGE, NETHER_BRIDGE_GATE, NETHER_TOWER, NETHER_WALL, NETHER_HALL, NETHER_FORT_STAIRS, NETHER_BRIDGE_X, NETHER_BRIDGE_END_X, NETHER_BRIDGE_Z, NETHER_BRIDGE_END_Z);
        TextureSet.stitchMutuallyHorizontally(NETHER_BRIDGE, NETHER_BRIDGE_GATE, NETHER_TOWER, NETHER_HALL, NETHER_FORT_STAIRS, NETHER_THRONE, NETHER_BRIDGE_X, NETHER_BRIDGE_END_X);
        TextureSet.stitchMutuallyVertically(NETHER_BRIDGE, NETHER_BRIDGE_GATE, NETHER_TOWER, NETHER_HALL, NETHER_FORT_STAIRS, NETHER_THRONE, NETHER_BRIDGE_Z, NETHER_BRIDGE_END_Z);
        TextureSet.stitchMutuallyHorizontally(NETHER_WALL, NETHER_HALL, NETHER_FORT_STAIRS);
        TextureSet.stitchMutuallyVertically(NETHER_WALL, NETHER_HALL, NETHER_FORT_STAIRS);
    }

    private static class TextureSetShore
    extends TextureSet {
        private final TextureSet water;

        TextureSetShore(String name, TextureSet water, ResourceLocation ... textures) {
            super(true, new ResourceLocation("antiqueatlas", name.toLowerCase(Locale.ROOT)), textures);
            this.water = water;
        }

        @Override
        public boolean shouldStitchToHorizontally(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToHorizontally(otherSet);
        }

        @Override
        public boolean shouldStitchToVertically(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToVertically(otherSet);
        }
    }
}

