/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureSetConfig
implements IResourceReloadListener<Collection<TextureSet>> {
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TextureSetMap textureSetMap;

    public TextureSetConfig(TextureSetMap textureSetMap) {
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Collection<TextureSet>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<TextureSet> sets = new ArrayList<TextureSet>();
            try {
                for (IResource resource : manager.func_199004_b(new ResourceLocation("antiqueatlas:texture_sets.json"))) {
                    try {
                        InputStream stream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonElement element = PARSER.parse((Reader)reader);
                                if (element.isJsonObject()) {
                                    JsonObject obj = element.getAsJsonObject();
                                    if (!obj.has("version")) {
                                        Log.warn("Invalid texture set file found!", new Object[0]);
                                        continue;
                                    }
                                    if (obj.get("version").getAsInt() < 1) {
                                        Log.warn("Outdated texture set file version: " + obj.get("version").getAsInt(), new Object[0]);
                                        continue;
                                    }
                                    for (Map.Entry entry : obj.get("data").getAsJsonObject().entrySet()) {
                                        String name = (String)entry.getKey();
                                        JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                                        ResourceLocation[] textures = new ResourceLocation[array.size()];
                                        for (int i = 0; i < array.size(); ++i) {
                                            String path = array.get(i).getAsString();
                                            textures[i] = new ResourceLocation(path);
                                        }
                                        sets.add(new TextureSet(AntiqueAtlasMod.id(name), textures));
                                    }
                                    continue;
                                }
                                Log.warn("Invalid texture set file found!", new Object[0]);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        Log.warn(e, "Failed to read texture set file!", new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read texture sets!", new Object[0]);
            }
            return sets;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Collection<TextureSet> sets, IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (TextureSet set : sets) {
                this.textureSetMap.register(set);
                Log.info("Loaded texture set %s with %d custom texture(s)", set.name, set.textures.length);
            }
        });
    }
}

