/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureSetMap
extends SaveData {
    private static final TextureSetMap INSTANCE = new TextureSetMap();
    private final Map<ResourceLocation, TextureSet> map = new HashMap<ResourceLocation, TextureSet>();

    public static TextureSetMap instance() {
        return INSTANCE;
    }

    public void register(TextureSet set) {
        TextureSet old = this.map.put(set.name, set);
        if (!set.equals(old)) {
            this.markDirty();
        }
    }

    public TextureSet getByName(ResourceLocation name) {
        return this.map.get(name);
    }

    public TextureSet getByNameNonNull(ResourceLocation name) {
        TextureSet set = this.getByName(name);
        return set == null ? TextureSet.TEST : set;
    }

    public boolean isRegistered(String name) {
        return this.map.containsKey(name);
    }

    public Collection<TextureSet> getAllTextureSets() {
        return this.map.values();
    }

    Collection<TextureSet> getAllNonStandardTextureSets() {
        ArrayList<TextureSet> list = new ArrayList<TextureSet>(this.map.size());
        for (TextureSet set : this.map.values()) {
            if (set.isStandard) continue;
            list.add(set);
        }
        return list;
    }
}

