/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.impl.atlas.util.AtlasRenderHelper;

public class GuiArrowButton
extends GuiComponentButton {
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;
    private static final int IMAGE_WIDTH = 24;
    private static final int IMAGE_HEIGHT = 24;
    private final ArrowDirection direction;

    private GuiArrowButton(ArrowDirection direction) {
        this.setSize(12, 12);
        this.direction = direction;
    }

    static GuiArrowButton up() {
        return new GuiArrowButton(ArrowDirection.UP);
    }

    static GuiArrowButton down() {
        return new GuiArrowButton(ArrowDirection.DOWN);
    }

    static GuiArrowButton left() {
        return new GuiArrowButton(ArrowDirection.LEFT);
    }

    static GuiArrowButton right() {
        return new GuiArrowButton(ArrowDirection.RIGHT);
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (this.isMouseOver) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int distanceSq = (mouseX - x - this.getWidth() / 2) * (mouseX - x - this.getWidth() / 2) + (mouseY - y - this.getHeight() / 2) * (mouseY - y - this.getHeight() / 2);
            double alpha = distanceSq < 400 ? 0.5 : Math.pow(distanceSq, -0.28);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        }
        int u = 0;
        int v = 0;
        switch (this.direction) {
            case LEFT: {
                u = 0;
                v = 0;
                break;
            }
            case RIGHT: {
                u = 0;
                v = 12;
                break;
            }
            case UP: {
                u = 12;
                v = 0;
                break;
            }
            case DOWN: {
                u = 12;
                v = 12;
            }
        }
        AtlasRenderHelper.drawTexturedRect(matrices, Textures.BTN_ARROWS, x, y, u, v, 12, 12, 24, 24);
        GlStateManager.func_227737_l_();
    }

    public static enum ArrowDirection {
        UP("Up"),
        DOWN("Down"),
        LEFT("Left"),
        RIGHT("Right");

        public final String description;

        private ArrowDirection(String text) {
            this.description = text;
        }
    }
}

