/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.impl.atlas.client.gui.GuiArrowButton;
import hunternif.mc.impl.atlas.client.gui.GuiBlinkingMarker;
import hunternif.mc.impl.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.impl.atlas.client.gui.GuiPositionButton;
import hunternif.mc.impl.atlas.client.gui.GuiScaleBar;
import hunternif.mc.impl.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.impl.atlas.client.gui.core.GuiCursor;
import hunternif.mc.impl.atlas.client.gui.core.GuiStates;
import hunternif.mc.impl.atlas.client.gui.core.IButtonListener;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.forge.hook.AntiqueAtlasHooks;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.BrowsingPositionC2SPacket;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.AtlasRenderHelper;
import hunternif.mc.impl.atlas.util.ExportImageUtil;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.MathUtil;
import hunternif.mc.impl.atlas.util.Rect;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int CONTENT_X = 17;
    private static final int CONTENT_Y = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    public static final int MARKER_SIZE = 32;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final double MIN_SCALE_THRESHOLD = 0.5;
    private final long[] renderTimes = new long[30];
    private int renderTimesIndex = 0;
    private final GuiStates state = new GuiStates();
    private final GuiStates.IState NORMAL = new GuiStates.SimpleState();
    private final GuiStates.IState HIDING_MARKERS = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((ITextComponent)new TranslationTextComponent("gui.antiqueatlas.showMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_SHOW_MARKERS);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((ITextComponent)new TranslationTextComponent("gui.antiqueatlas.hideMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_HIDE_MARKERS);
        }
    };
    private final GuiStates.IState PLACING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnMarker.setSelected(false);
        }
    };
    private final GuiStates.IState DELETING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.addChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.removeChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(false);
        }
    };
    private final GuiCursor eraser = new GuiCursor();
    private final GuiStates.IState EXPORTING_IMAGE = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnExportPng.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnExportPng.setSelected(false);
        }
    };
    private final GuiArrowButton btnUp;
    private final GuiArrowButton btnDown;
    private final GuiArrowButton btnLeft;
    private final GuiArrowButton btnRight;
    private final GuiBookmarkButton btnExportPng;
    private final GuiBookmarkButton btnMarker;
    private final GuiBookmarkButton btnDelMarker;
    private final GuiBookmarkButton btnShowMarkers;
    private final GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    private static final int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int mapOffsetX;
    private int mapOffsetY;
    private boolean followPlayer;
    private final GuiScaleBar scaleBar = new GuiScaleBar();
    private double mapScale;
    private int tileHalfSize;
    private int tile2ChunkScale;
    private DimensionMarkersData localMarkersData;
    private DimensionMarkersData globalMarkersData;
    private Marker hoveredMarker;
    private final GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private final GuiBlinkingMarker blinkingIcon = new GuiBlinkingMarker();
    private PlayerEntity player;
    private ItemStack stack;
    private WorldData biomeData;
    private double screenScale;
    private final ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);
    private long lastUpdateMillis = System.currentTimeMillis();
    private int scaleAlpha = 255;
    private int scaleClipIndex = 0;
    private final int zoomLevelOne = 8;
    private int zoomLevel = 8;
    private final String[] zoomNames = new String[]{"256", "128", "64", "32", "16", "8", "4", "2", "1", "1/2", "1/4", "1/8", "1/16", "1/32", "1/64", "1/128", "1/256"};
    private Thread exportThread;

    public GuiAtlas() {
        this.setSize(310, 218);
        this.setMapScale(0.5);
        this.followPlayer = true;
        this.setInterceptKeyboard(true);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener<GuiComponentButton> positionListener = button -> {
            this.selectedButton = button;
            if (((Object)((Object)button)).equals((Object)this.btnPosition)) {
                this.followPlayer = true;
                this.btnPosition.setEnabled(false);
            } else {
                this.navigateByButton(this.selectedButton);
                this.timeButtonPressed = this.player.func_130014_f_().func_82737_E();
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(1, Textures.ICON_EXPORT, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.exportImage")){

            @Override
            public boolean isEnabled() {
                return !ExportImageUtil.isExporting;
            }
        };
        this.addChild(this.btnExportPng).offsetGuiCoords(300, 75);
        this.btnExportPng.addListener(button -> {
            if (this.stack != null || !((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
                this.exportThread = new Thread(() -> this.exportImage(this.getAtlasID()), "Atlas file export thread");
                this.exportThread.start();
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_ADD_MARKER, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.addMarker"));
        this.addChild(this.btnMarker).offsetGuiCoords(300, 14);
        this.btnMarker.addListener(button -> {
            if (this.state.is(this.PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
                this.selectedButton = button;
                this.state.switchTo(this.PLACING_MARKER);
                if (GuiAtlas.func_231173_s_()) {
                    this.markerFinalizer.setMarkerData(this.player.func_130014_f_(), this.getAtlasID(), (int)this.player.func_226277_ct_(), (int)this.player.func_226281_cx_());
                    this.addChild(this.markerFinalizer);
                    this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getIcon(), 32, 32);
                    this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(this.worldXToScreenX((int)this.player.func_226277_ct_()) - this.getGuiX() - 16, this.worldZToScreenY((int)this.player.func_226281_cx_()) - this.getGuiY() - 16);
                    this.setInterceptKeyboard(true);
                    KeyBinding.func_74506_a();
                    this.selectedButton = null;
                    this.state.switchTo(this.NORMAL);
                }
            }
        });
        this.btnDelMarker = new GuiBookmarkButton(2, Textures.ICON_DELETE_MARKER, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.delMarker"));
        this.addChild(this.btnDelMarker).offsetGuiCoords(300, 33);
        this.btnDelMarker.addListener(button -> {
            if (this.state.is(this.DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
                this.selectedButton = button;
                this.state.switchTo(this.DELETING_MARKER);
            }
        });
        this.btnShowMarkers = new GuiBookmarkButton(3, Textures.ICON_HIDE_MARKERS, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.hideMarkers"));
        this.addChild(this.btnShowMarkers).offsetGuiCoords(300, 52);
        this.btnShowMarkers.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(this.HIDING_MARKERS)) {
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
                this.selectedButton = null;
                this.state.switchTo(this.HIDING_MARKERS);
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 198);
        this.scaleBar.setMapScale(1.0);
        this.markerFinalizer.addMarkerListener(this.blinkingIcon);
        this.eraser.setTexture(Textures.ERASER, 12, 14, 2, 11);
    }

    public GuiAtlas prepareToOpen(ItemStack stack) {
        this.stack = stack;
        return this.prepareToOpen();
    }

    public GuiAtlas prepareToOpen() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.updateAtlasData();
        if (!this.followPlayer && ((Boolean)AntiqueAtlasConfig.doSaveBrowsingPos.get()).booleanValue()) {
            this.loadSavedBrowsingPosition();
        }
        return this;
    }

    public void loadSavedBrowsingPosition() {
        this.setMapScale(this.biomeData.getBrowsingZoom());
        this.mapOffsetX = this.biomeData.getBrowsingX();
        this.mapOffsetY = this.biomeData.getBrowsingY();
        this.isDragging = false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.state.switchTo(this.NORMAL);
        }
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        this.screenScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        this.setCentered();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseState) {
        boolean isMouseOverMap;
        boolean result = super.func_231044_a_(mouseX, mouseY, mouseState);
        if (this.state.is(this.EXPORTING_IMAGE)) {
            return result;
        }
        if (result) {
            return true;
        }
        if (mouseState == 1 && this.state.is(this.NORMAL)) {
            this.func_231164_f_();
            return true;
        }
        int mapX = (this.field_230708_k_ - 276) / 2;
        int mapY = (this.field_230709_l_ - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= (double)mapX && mouseX <= (double)(mapX + 276) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 194);
        if (!this.state.is(this.NORMAL) && !this.state.is(this.HIDING_MARKERS)) {
            int atlasID = this.getAtlasID();
            if (this.state.is(this.PLACING_MARKER) && isMouseOverMap && mouseState == 0) {
                this.markerFinalizer.setMarkerData(this.player.func_130014_f_(), atlasID, this.screenXToWorldX((int)mouseX), this.screenYToWorldZ((int)mouseY));
                this.addChild(this.markerFinalizer);
                this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getIcon(), 32, 32);
                this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords((int)mouseX - this.getGuiX() - 16, (int)mouseY - this.getGuiY() - 16);
                this.setInterceptKeyboard(true);
                KeyBinding.func_74506_a();
                this.state.switchTo(this.NORMAL);
                return true;
            }
            if (this.state.is(this.DELETING_MARKER) && this.hoveredMarker != null && !this.hoveredMarker.isGlobal() && isMouseOverMap && mouseState == 0) {
                AtlasAPI.markers.deleteMarker(this.player.func_130014_f_(), atlasID, this.hoveredMarker.getId());
                this.hoveredMarker = null;
                this.player.func_130014_f_().func_184133_a(this.player, this.player.func_233580_cy_(), SoundEvents.field_219718_mk, SoundCategory.AMBIENT, 1.0f, 0.5f);
            }
            this.state.switchTo(this.NORMAL);
        } else if (isMouseOverMap && this.selectedButton == null && this.hoveredMarker == null) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    private void exportImage(int atlasID) {
        boolean showMarkers = !this.state.is(this.HIDING_MARKERS);
        this.state.switchTo(this.EXPORTING_IMAGE);
        ExportImageUtil.isExporting = true;
        File screenshot_folder = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
        if (!screenshot_folder.isDirectory()) {
            screenshot_folder.mkdir();
        }
        String outputname = "atlas-" + DATE_FORMAT.format(new Date());
        File file = new File(screenshot_folder, outputname + ".png");
        int i = 1;
        while (file.exists()) {
            file = new File(screenshot_folder, outputname + "_" + i + ".png");
            ++i;
        }
        try {
            Log.info("Exporting image from Atlas #%d to file %s", atlasID, file.getAbsolutePath());
            ExportImageUtil.exportPngImage(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            Log.info("Finished exporting image", new Object[0]);
        }
        catch (OutOfMemoryError e) {
            Log.warn(e, "Image is too large, trying to export in strips", new Object[0]);
            try {
                ExportImageUtil.exportPngImageTooLarge(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            }
            catch (OutOfMemoryError e2) {
                int minX = (this.biomeData.getScope().minX - 1) * 16;
                int minY = (this.biomeData.getScope().minY - 1) * 16;
                int outWidth = (this.biomeData.getScope().maxX + 2) * 16 - minX;
                int outHeight = (this.biomeData.getScope().maxY + 2) * 16 - minY;
                Log.error(e2, "Image is STILL too large, how massive is this map?! Answer: (%dx%d)", outWidth, outHeight);
                ExportUpdateListener.INSTANCE.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.tooLarge", (Object[])new Object[0]), new Object[0]);
                ExportImageUtil.isExporting = false;
                return;
            }
        }
        ExportImageUtil.isExporting = false;
        this.state.switchTo(showMarkers ? this.NORMAL : this.HIDING_MARKERS);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.setMapScale(this.mapScale * 2.0);
        } else if (keyCode == 45 || keyCode == 333) {
            this.setMapScale(this.mapScale / 2.0);
        } else if (keyCode == 256) {
            this.func_231175_as__();
        } else {
            KeyBinding[] hotbarKeys;
            for (KeyBinding bind : hotbarKeys = Minecraft.func_71410_x().field_71474_y.field_151456_ac) {
                if (!bind.func_197976_a(keyCode, scanCode) || this.markerFinalizer.getParent() != null) continue;
                this.func_231175_as__();
                return false;
            }
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    @Override
    public boolean func_231043_a_(double mx, double my, double wheelMove) {
        double origWheelMove = wheelMove;
        boolean handled = super.func_231043_a_(mx, my, origWheelMove);
        if (!handled && wheelMove != 0.0) {
            double d = wheelMove = wheelMove > 0.0 ? 1.0 : -1.0;
            if (((Boolean)AntiqueAtlasConfig.doReverseWheelZoom.get()).booleanValue()) {
                wheelMove *= -1.0;
            }
            double mouseOffsetX = (double)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / this.screenScale / 2.0 - this.getMouseX();
            double mouseOffsetY = (double)Minecraft.func_71410_x().func_228018_at_().func_198091_l() / this.screenScale / 2.0 - this.getMouseY();
            double newScale = this.mapScale * Math.pow(2.0, wheelMove);
            double addOffsetX = 0.0;
            double addOffsetY = 0.0;
            if (Math.abs(mouseOffsetX) < 138.0 && Math.abs(mouseOffsetY) < 97.0) {
                addOffsetX = mouseOffsetX * wheelMove;
                addOffsetY = mouseOffsetY * wheelMove;
                if (wheelMove > 0.0) {
                    addOffsetX *= this.mapScale / newScale;
                    addOffsetY *= this.mapScale / newScale;
                }
            }
            this.setMapScale(newScale, (int)addOffsetX, (int)addOffsetY);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
            return true;
        }
        return handled;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetX += (int)deltaX;
            this.mapOffsetY += (int)deltaY;
            result = true;
        }
        return super.func_231045_a_(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.player == null) {
            return;
        }
        if (this.followPlayer) {
            this.mapOffsetX = (int)(-this.player.func_226277_ct_() * this.mapScale);
            this.mapOffsetY = (int)(-this.player.func_226281_cx_() * this.mapScale);
        }
        if (this.player.func_130014_f_().func_82737_E() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
        this.updateAtlasData();
    }

    private void updateAtlasData() {
        int atlasID = this.getAtlasID();
        this.biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, this.player.func_130014_f_()).getWorldData((RegistryKey<World>)this.player.func_130014_f_().func_234923_W_());
        this.globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((RegistryKey<World>)this.player.func_130014_f_().func_234923_W_());
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, this.player.func_130014_f_());
        this.localMarkersData = markersData != null ? markersData.getMarkersDataInWorld((RegistryKey<World>)this.player.func_130014_f_().func_234923_W_()) : null;
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, 24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(24, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-24, 0);
        }
    }

    private void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    public void setMapScale(double scale) {
        this.setMapScale(scale, 0, 0);
    }

    private void setMapScale(double scale, int addOffsetX, int addOffsetY) {
        double oldScale = this.mapScale;
        this.mapScale = Math.min(Math.max(scale, (Double)AntiqueAtlasConfig.minScale.get()), (Double)AntiqueAtlasConfig.maxScale.get());
        if (oldScale == this.mapScale) {
            return;
        }
        if (this.mapScale >= 0.5) {
            this.tileHalfSize = (int)Math.round(8.0 * this.mapScale);
            this.tile2ChunkScale = 1;
        } else {
            this.tileHalfSize = (int)Math.round(4.0);
            this.tile2ChunkScale = (int)Math.round(0.5 / this.mapScale);
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)(this.mapOffsetX + addOffsetX) * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)(this.mapOffsetY + addOffsetY) * (this.mapScale / oldScale));
        this.scaleClipIndex = MathHelper.func_151239_c((int)((int)(this.mapScale * 8192.0))) + 1 - 13;
        this.zoomLevel = -this.scaleClipIndex + 8;
        this.scaleAlpha = 255;
        if (this.followPlayer && (addOffsetX != 0 || addOffsetY != 0)) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float par3) {
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastUpdateMillis;
        this.lastUpdateMillis = currentMillis;
        if (((Boolean)AntiqueAtlasConfig.debugRender.get()).booleanValue()) {
            this.renderTimes[this.renderTimesIndex++] = System.currentTimeMillis();
            if (this.renderTimesIndex == this.renderTimes.length) {
                this.renderTimesIndex = 0;
                double elapsed = 0.0;
                for (int i = 0; i < this.renderTimes.length - 1; ++i) {
                    elapsed += (double)(this.renderTimes[i + 1] - this.renderTimes[i]);
                }
                System.out.printf("GuiAtlas avg. render time: %.3f\n", elapsed / (double)this.renderTimes.length);
            }
        }
        super.func_230446_a_(matrices);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(matrices, Textures.BOOK, this.getGuiX(), this.getGuiY(), 310, 218);
        if (this.stack == null && ((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue() || this.biomeData == null) {
            return;
        }
        if (this.state.is(this.DELETING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        RenderSystem.enableScissor((int)((int)((double)(this.getGuiX() + 17) * this.screenScale)), (int)((int)((double)Minecraft.func_71410_x().func_228018_at_().func_198091_l() - (double)(this.getGuiY() + 11 + 194) * this.screenScale)), (int)((int)(276.0 * this.screenScale)), (int)((int)(194.0 * this.screenScale)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int mapStartX = MathUtil.roundToBase((int)Math.floor(-(138.0 + (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartZ = MathUtil.roundToBase((int)Math.floor(-(97.0 + (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndX = MathUtil.roundToBase((int)Math.ceil((138.0 - (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndZ = MathUtil.roundToBase((int)Math.ceil((97.0 - (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartScreenX = this.getGuiX() + 155 + (int)((double)(mapStartX << 4) * this.mapScale) + this.mapOffsetX;
        int mapStartScreenY = this.getGuiY() + 109 + (int)((double)(mapStartZ << 4) * this.mapScale) + this.mapOffsetY;
        TileRenderIterator iter = new TileRenderIterator(this.biomeData);
        iter.setScope(new Rect().setOrigin(mapStartX, mapStartZ).set(mapStartX, mapStartZ, mapEndX, mapEndZ));
        iter.setStep(this.tile2ChunkScale);
        boolean v = true;
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                AtlasRenderHelper.drawAutotileCorner(BiomeTextureMap.instance().getTexture(subtile.variationNumber, subtile.tile), mapStartScreenX + subtile.x * this.tileHalfSize, mapStartScreenY + subtile.y * this.tileHalfSize, subtile.getTextureU(), subtile.getTextureV(), this.tileHalfSize);
            }
        }
        int markersStartX = MathUtil.roundToBase(mapStartX, 8) / 8 - 1;
        int markersStartZ = MathUtil.roundToBase(mapStartZ, 8) / 8 - 1;
        int markersEndX = MathUtil.roundToBase(mapEndX, 8) / 8 + 1;
        int markersEndZ = MathUtil.roundToBase(mapEndZ, 8) / 8 + 1;
        this.renderMarkers(matrices, mouseX, mouseY, markersStartX, markersStartZ, markersEndX, markersEndZ, this.globalMarkersData);
        this.renderMarkers(matrices, mouseX, mouseY, markersStartX, markersStartZ, markersEndX, markersEndZ, this.localMarkersData);
        RenderSystem.disableScissor();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(matrices, Textures.BOOK_FRAME, this.getGuiX(), this.getGuiY(), 310, 218);
        this.renderScaleOverlay(matrices, deltaMillis);
        double iconScale = this.getIconScale();
        if (!this.state.is(this.HIDING_MARKERS)) {
            int playerOffsetX = (int)(this.player.func_226277_ct_() * this.mapScale) + this.mapOffsetX;
            int playerOffsetZ = (int)(this.player.func_226281_cx_() * this.mapScale) + this.mapOffsetY;
            if (playerOffsetX < -138) {
                playerOffsetX = -138;
            }
            if (playerOffsetX > 138) {
                playerOffsetX = 138;
            }
            if (playerOffsetZ < -97) {
                playerOffsetZ = -97;
            }
            if (playerOffsetZ > 95) {
                playerOffsetZ = 95;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(this.PLACING_MARKER) ? 0.5f : 1.0f));
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(this.getGuiX() + 155 + playerOffsetX), (double)(this.getGuiY() + 109 + playerOffsetZ), 0.0);
            float playerRotation = (float)Math.round(this.player.field_70177_z / 360.0f * 16.0f) / 16.0f * 360.0f;
            matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f + playerRotation));
            matrices.func_227861_a_((double)((float)(-3.0 * iconScale)), (double)((float)(-4.0 * iconScale)), 0.0);
            AtlasRenderHelper.drawFullTexture(matrices, Textures.PLAYER, 0.0, 0.0, (int)Math.round(7.0 * iconScale), (int)Math.round(8.0 * iconScale));
            matrices.func_227865_b_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, par3);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.markerFinalizer.selectedType.calculateMip(iconScale, this.mapScale, this.screenScale);
            MarkerRenderInfo renderInfo = this.markerFinalizer.selectedType.getRenderInfo(iconScale, this.mapScale, this.screenScale);
            this.markerFinalizer.selectedType.resetMip();
            AtlasRenderHelper.drawFullTexture(matrices, renderInfo.tex, (double)mouseX + renderInfo.x, (double)mouseY + renderInfo.y, renderInfo.width, renderInfo.height);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.func_230446_a_(matrices);
            this.progressBar.draw(matrices, (this.field_230708_k_ - 100) / 2, this.field_230709_l_ / 2 - 34);
        }
    }

    private void renderMarkers(MatrixStack matrices, int mouseX, int mouseY, int markersStartX, int markersStartZ, int markersEndX, int markersEndZ, DimensionMarkersData markersData) {
        if (markersData == null) {
            return;
        }
        for (int x = markersStartX; x <= markersEndX; ++x) {
            for (int z = markersStartZ; z <= markersEndZ; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    this.renderMarker(matrices, mouseX, mouseY, marker, this.getIconScale());
                }
            }
        }
    }

    private void renderScaleOverlay(MatrixStack matrices, long deltaMillis) {
        if (this.scaleAlpha > 3) {
            int textWidth;
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(this.getGuiX() + 310 - 13), (double)(this.getGuiY() + 12), 0.0);
            int color = this.scaleAlpha << 24;
            String text = "x";
            int xWidth = textWidth = this.field_230712_o_.func_78256_a(text);
            ++xWidth;
            this.field_230712_o_.func_238421_b_(matrices, text, (float)(-textWidth), 0.0f, this.scaleAlpha << 24);
            text = this.zoomNames[this.zoomLevel];
            if (text.contains("/")) {
                String[] parts = text.split("/");
                int centerXtranslate = Math.max(this.field_230712_o_.func_78256_a(parts[0]), this.field_230712_o_.func_78256_a(parts[1])) / 2;
                double d = -xWidth - centerXtranslate;
                this.field_230712_o_.getClass();
                matrices.func_227861_a_(d, (double)((float)(-9) / 2.0f), 0.0);
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)this.scaleAlpha / 255.0f));
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.disableTexture();
                Tessellator t = Tessellator.func_178181_a();
                BufferBuilder vb = t.func_178180_c();
                Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
                vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                float f = centerXtranslate;
                this.field_230712_o_.getClass();
                vb.func_227888_a_(matrix, f, (float)(9 - 1), 0.0f).func_181675_d();
                float f2 = -centerXtranslate - 1;
                this.field_230712_o_.getClass();
                vb.func_227888_a_(matrix, f2, (float)(9 - 1), 0.0f).func_181675_d();
                float f3 = -centerXtranslate - 1;
                this.field_230712_o_.getClass();
                vb.func_227888_a_(matrix, f3, 9.0f, 0.0f).func_181675_d();
                float f4 = centerXtranslate;
                this.field_230712_o_.getClass();
                vb.func_227888_a_(matrix, f4, 9.0f, 0.0f).func_181675_d();
                t.func_78381_a();
                RenderSystem.enableTexture();
                RenderSystem.disableBlend();
                textWidth = this.field_230712_o_.func_78256_a(parts[0]);
                this.field_230712_o_.func_238421_b_(matrices, parts[0], (float)(-textWidth) / 2.0f, 0.0f, color);
                textWidth = this.field_230712_o_.func_78256_a(parts[1]);
                this.field_230712_o_.func_238421_b_(matrices, parts[1], (float)(-textWidth) / 2.0f, 10.0f, color);
            } else {
                textWidth = this.field_230712_o_.func_78256_a(text);
                this.field_230712_o_.func_238421_b_(matrices, text, (float)(-textWidth - xWidth + 1), 2.0f, this.scaleAlpha << 24);
            }
            matrices.func_227865_b_();
            int deltaScaleAlpha = (int)((double)deltaMillis * 0.256);
            if (deltaScaleAlpha == 0) {
                deltaScaleAlpha = 1;
            }
            this.scaleAlpha -= deltaScaleAlpha;
            if (this.scaleAlpha < 0) {
                this.scaleAlpha = 0;
            }
        }
    }

    private void renderMarker(MatrixStack matrices, int mouseX, int mouseY, Marker marker, double scale) {
        MarkerType type = (MarkerType)MarkerType.REGISTRY.func_82594_a(marker.getType());
        if (type == null) {
            Log.warn("Could not find marker data for %s. Is it in the config file?\n", marker.getType());
            return;
        }
        if (type.shouldHide(this.state.is(this.HIDING_MARKERS), this.scaleClipIndex)) {
            return;
        }
        int markerX = this.worldXToScreenX(marker.getX());
        int markerY = this.worldZToScreenY(marker.getZ());
        if (!marker.isVisibleAhead() && !this.biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        type.calculateMip(scale, this.mapScale, this.screenScale);
        MarkerRenderInfo info = type.getRenderInfo(scale, this.mapScale, this.screenScale);
        boolean mouseIsOverMarker = type.shouldHover((this.getMouseX() - ((double)markerX + info.x)) / (double)info.width, (this.getMouseY() - ((double)markerY + info.y)) / (double)info.height);
        type.resetMip();
        if (mouseIsOverMarker) {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.hoveredMarker = marker;
            AntiqueAtlasHooks.fireMarkerHovered(this.player, marker);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hoveredMarker == marker) {
                this.hoveredMarker = null;
            }
        }
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else if (this.state.is(this.DELETING_MARKER) && marker.isGlobal()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((Boolean)AntiqueAtlasConfig.debugRender.get()).booleanValue()) {
            System.out.println("Rendering Marker: " + info.tex);
        }
        AtlasRenderHelper.drawFullTexture(matrices, info.tex, (double)markerX + info.x, (double)markerY + info.y, info.width, info.height);
        if (this.isMouseOver && mouseIsOverMarker && marker.getLabel().getString().length() > 0) {
            this.drawTooltip(Collections.singletonList(marker.getLabel()), this.field_230712_o_);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        this.markerFinalizer.close();
        this.removeChild(this.blinkingIcon);
        this.biomeData.setBrowsingPosition(this.mapOffsetX, this.mapOffsetY, this.mapScale);
        new BrowsingPositionC2SPacket(this.getAtlasID(), (RegistryKey<World>)this.player.func_130014_f_().func_234923_W_(), this.mapOffsetX, this.mapOffsetY, this.mapScale).send();
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.field_230708_k_ / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.field_230709_l_ / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)((float)this.field_230708_k_ / 2.0f) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)((float)this.field_230709_l_ / 2.0f) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.setInterceptKeyboard(true);
            this.removeChild(this.blinkingIcon);
        }
    }

    public void updateL18n() {
        this.btnExportPng.setTitle((ITextComponent)new TranslationTextComponent("gui.antiqueatlas.exportImage"));
        this.btnMarker.setTitle((ITextComponent)new TranslationTextComponent("gui.antiqueatlas.addMarker"));
    }

    private double getIconScale() {
        return ((Boolean)AntiqueAtlasConfig.doScaleMarkers.get()).booleanValue() ? (this.mapScale < 0.5 ? 0.5 : (this.mapScale > 1.0 ? 2.0 : 1.0)) : 1.0;
    }

    private int getAtlasID() {
        return (Boolean)AntiqueAtlasConfig.itemNeeded.get() != false ? AtlasItem.getAtlasID(this.stack) : this.player.func_110124_au().hashCode();
    }
}

