/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import hunternif.mc.api.client.MarkerRegistry;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerInList;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.impl.atlas.client.gui.core.ToggleGroup;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiMarkerFinalizer
extends GuiComponent {
    private World world;
    private int atlasID;
    private int markerX;
    private int markerZ;
    MarkerType selectedType = (MarkerType)MarkerType.REGISTRY.func_82594_a(MarkerType.REGISTRY.func_212609_b());
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SPACING = 4;
    private static final int TYPE_SPACING = 1;
    private static final int TYPE_BG_FRAME = 4;
    private Button btnDone;
    private Button btnCancel;
    private TextFieldWidget textField;
    private GuiScrollingContainer scroller;
    private ToggleGroup<GuiMarkerInList> typeRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    GuiMarkerFinalizer() {
    }

    void setMarkerData(World world, int atlasID, int markerX, int markerZ) {
        this.world = world;
        this.atlasID = atlasID;
        this.markerX = markerX;
        this.markerZ = markerZ;
        this.setBlocksScreen(true);
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    void removeMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.remove(listener);
    }

    void removeAllMarkerListeners() {
        this.markerListeners.clear();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.btnDone = new Button(this.field_230708_k_ / 2 - 100 - 2, this.field_230709_l_ / 2 + 40, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> {
            MarkerRegistry.API.putMarker(this.world, true, this.atlasID, this.selectedType, (ITextComponent)new StringTextComponent(this.textField.func_146179_b()), this.markerX, this.markerZ);
            Log.info("Put marker in Atlas #%d \"%s\" at (%d, %d)", this.atlasID, this.textField.func_146179_b(), this.markerX, this.markerZ);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            this.world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_219696_mD, SoundCategory.AMBIENT, 1.0f, 1.0f);
            this.close();
        });
        this.func_230480_a_((Widget)this.btnDone);
        this.btnCancel = new Button(this.field_230708_k_ / 2 + 2, this.field_230709_l_ / 2 + 40, 100, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.close());
        this.func_230480_a_((Widget)this.btnCancel);
        this.textField = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, (this.field_230708_k_ - 200) / 2, this.field_230709_l_ / 2 - 81, 200, 20, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.marker.label"));
        this.textField.func_146184_c(true);
        this.textField.func_146180_a("");
        this.scroller = new GuiScrollingContainer();
        this.scroller.setWheelScrollsHorizontally();
        this.addChild(this.scroller);
        int typeCount = 0;
        for (MarkerType type : MarkerType.REGISTRY) {
            if (type.isTechnical()) continue;
            ++typeCount;
        }
        int allTypesWidth = typeCount * 35 - 1;
        int scrollerWidth = Math.min(allTypesWidth, 240);
        this.scroller.setViewportSize(scrollerWidth, 34);
        this.scroller.setGuiCoords((this.field_230708_k_ - scrollerWidth) / 2, this.field_230709_l_ / 2 - 25);
        this.typeRadioGroup = new ToggleGroup();
        this.typeRadioGroup.addListener(button -> {
            this.selectedType = button.getMarkerType();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType(button.getMarkerType());
            }
        });
        int contentX = 0;
        for (MarkerType markerType : MarkerType.REGISTRY) {
            if (markerType.isTechnical()) continue;
            GuiMarkerInList markerGui = new GuiMarkerInList(markerType);
            this.typeRadioGroup.addButton(markerGui);
            if (this.selectedType.equals(markerType)) {
                this.typeRadioGroup.setSelectedButton(markerGui);
            }
            this.scroller.addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.scroller != null) {
            this.scroller.close();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button) || this.textField.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231046_a_(int aa, int bb, int cc) {
        return super.func_231046_a_(aa, bb, cc) || this.textField.func_231046_a_(aa, bb, cc);
    }

    @Override
    public boolean func_231042_a_(char aa, int bb) {
        return super.func_231042_a_(aa, bb) || this.textField.func_231042_a_(aa, bb);
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(matrices);
        this.drawCentered(matrices, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.marker.label"), this.field_230709_l_ / 2 - 97, 0xFFFFFF, true);
        this.textField.func_230430_a_(matrices, mouseX, mouseY, partialTick);
        this.drawCentered(matrices, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.marker.type"), this.field_230709_l_ / 2 - 44, 0xFFFFFF, true);
        this.func_238468_a_(matrices, this.scroller.getGuiX() - 4, this.scroller.getGuiY() - 4, this.scroller.getGuiX() + this.scroller.getWidth() + 4, this.scroller.getGuiY() + this.scroller.getHeight() + 4, -2012213232, -1727000560);
        super.func_230430_a_(matrices, mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerType var1);
    }
}

