/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.BiomeDetectorBase;
import hunternif.mc.impl.atlas.core.BiomeDetectorEnd;
import hunternif.mc.impl.atlas.core.BiomeDetectorNether;
import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MapDataS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.ShortVec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.WorldSavedData;

public class AtlasData
extends WorldSavedData {
    public static final int VERSION = 4;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_WORLD_MAP_LIST = "qWorldMap";
    public static final String TAG_WORLD_ID = "qWorldID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<RegistryKey<World>, IBiomeDetector> biomeAnalyzers = new HashMap<RegistryKey<World>, IBiomeDetector>();
    private final BiomeDetectorBase biomeDetectorOverworld = new BiomeDetectorBase();
    private final BiomeDetectorNether biomeDetectorNether = new BiomeDetectorNether();
    private final BiomeDetectorEnd biomeDetectorEnd = new BiomeDetectorEnd();
    private final Map<RegistryKey<World>, WorldData> worldMap = new ConcurrentHashMap<RegistryKey<World>, WorldData>(2, 0.75f, 2);
    private final Set<PlayerEntity> playersSentTo = new HashSet<PlayerEntity>();
    private CompoundNBT nbt;

    public AtlasData(String key) {
        super(key);
        this.biomeDetectorOverworld.setScanPonds((Boolean)AntiqueAtlasConfig.doScanPonds.get());
        this.biomeDetectorOverworld.setScanRavines((Boolean)AntiqueAtlasConfig.doScanRavines.get());
        this.setBiomeDetectorForDimension((RegistryKey<World>)World.field_234918_g_, this.biomeDetectorOverworld);
        this.setBiomeDetectorForDimension((RegistryKey<World>)World.field_234919_h_, this.biomeDetectorNether);
        this.setBiomeDetectorForDimension((RegistryKey<World>)World.field_234920_i_, this.biomeDetectorEnd);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.nbt = compound;
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d.", version, 4);
            return;
        }
        ListNBT worldMapList = compound.func_150295_c(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < worldMapList.size(); ++d) {
            CompoundNBT worldTag = worldMapList.func_150305_b(d);
            RegistryKey worldID = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldTag.func_74779_i(TAG_WORLD_ID)));
            ListNBT dimensionTag = (ListNBT)worldTag.func_74781_a(TAG_VISITED_CHUNKS);
            WorldData dimData = this.getWorldData((RegistryKey<World>)worldID);
            dimData.readFromNBT(dimensionTag);
            double zoom = worldTag.func_74769_h(TAG_BROWSING_ZOOM);
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(worldTag.func_74762_e(TAG_BROWSING_X), worldTag.func_74762_e(TAG_BROWSING_Y), zoom);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        return this.writeToNBT(compound, true);
    }

    public CompoundNBT writeToNBT(CompoundNBT compound, boolean includeTileData) {
        ListNBT dimensionMapList = new ListNBT();
        compound.func_74768_a(TAG_VERSION, 4);
        for (Map.Entry<RegistryKey<World>, WorldData> dimensionEntry : this.worldMap.entrySet()) {
            CompoundNBT dimTag = new CompoundNBT();
            dimTag.func_74778_a(TAG_WORLD_ID, dimensionEntry.getKey().func_240901_a_().toString());
            WorldData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.func_218657_a(TAG_VISITED_CHUNKS, (INBT)dimData.writeToNBT());
            }
            dimTag.func_74768_a(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.func_74768_a(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.func_74780_a(TAG_BROWSING_ZOOM, dimData.getBrowsingZoom());
            dimensionMapList.add((Object)dimTag);
        }
        compound.func_218657_a(TAG_WORLD_MAP_LIST, (INBT)dimensionMapList);
        return compound;
    }

    private void setBiomeDetectorForDimension(RegistryKey<World> dimension, IBiomeDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(dimension, biomeAnalyzer);
    }

    private IBiomeDetector getBiomeDetectorForDimension(RegistryKey<World> dimension) {
        IBiomeDetector biomeAnalyzer = this.biomeAnalyzers.get(dimension);
        return biomeAnalyzer == null ? this.biomeDetectorOverworld : biomeAnalyzer;
    }

    public Collection<TileInfo> updateMapAroundPlayer(PlayerEntity player) {
        int newScanInterval = Math.round(((Double)AntiqueAtlasConfig.newScanInterval.get()).floatValue() * 20.0f);
        if (player.func_130014_f_().func_82737_E() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * (Integer)AntiqueAtlasConfig.rescanRate.get();
        boolean rescanRequired = (Boolean)AntiqueAtlasConfig.doRescan.get() != false && player.func_130014_f_().func_82737_E() % (long)rescanInterval == 0L;
        int scanRadius = (Integer)AntiqueAtlasConfig.scanRadius.get();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.field_70176_ah + dx;
                int chunkZ = player.field_70164_aj + dz;
                TileInfo update = this.updateMapChunk(player.func_130014_f_(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateMapChunk(World world, int x, int z, boolean rescanRequired) {
        WorldData seenChunks = this.getWorldData((RegistryKey<World>)world.func_234923_W_());
        ResourceLocation oldTile = seenChunks.getTile(x, z);
        ResourceLocation tile = null;
        tile = AntiqueAtlasMod.tileData.getData(world).getTile(x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            IChunk chunk = world.func_217353_a(x, z, ChunkStatus.field_222617_m, ((Boolean)AntiqueAtlasConfig.forceChunkLoading.get()).booleanValue());
            if (chunk == null) {
                return null;
            }
            IBiomeDetector biomeDetector = this.getBiomeDetectorForDimension((RegistryKey<World>)world.func_234923_W_());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    this.removeTile((RegistryKey<World>)world.func_234923_W_(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    this.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                this.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            this.setTile((RegistryKey<World>)world.func_234923_W_(), x, z, tile);
            this.func_76185_a();
            return new TileInfo(x, z, tile);
        }
        return null;
    }

    public void setTile(RegistryKey<World> world, int x, int y, ResourceLocation tile) {
        WorldData worldData = this.getWorldData(world);
        worldData.setTile(x, y, tile);
    }

    private ResourceLocation removeTile(RegistryKey<World> world, int x, int y) {
        WorldData dimData = this.getWorldData(world);
        return dimData.removeTile(x, y);
    }

    public Set<RegistryKey<World>> getVisitedWorlds() {
        return this.worldMap.keySet();
    }

    public WorldData getWorldData(RegistryKey<World> world) {
        return this.worldMap.computeIfAbsent(world, k -> new WorldData(this, world));
    }

    public Map<ShortVec2, ResourceLocation> getSeenChunksInDimension(RegistryKey<World> world) {
        return this.getWorldData(world).getSeenChunks();
    }

    public Collection<PlayerEntity> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(PlayerEntity player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, PlayerEntity player) {
        if (this.nbt == null) {
            this.nbt = new CompoundNBT();
        }
        this.writeToNBT(this.nbt, false);
        new MapDataS2CPacket(atlasID, this.nbt).send((ServerPlayerEntity)player);
        for (RegistryKey<World> world : this.worldMap.keySet()) {
            this.worldMap.get(world).syncOnPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.func_195051_bN().func_197037_c());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.worldMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.worldMap.size() != this.worldMap.size()) {
            return false;
        }
        for (RegistryKey<World> key : this.worldMap.keySet()) {
            if (this.worldMap.get(key).equals(other.worldMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

