/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;

public class AtlasDataHandler {
    private static final String ATLAS_DATA_PREFIX = "aAtlas_";
    private final Map<String, AtlasData> atlasDataClientCache = new ConcurrentHashMap<String, AtlasData>();

    public AtlasData getAtlasData(ItemStack stack, World world) {
        if (stack.func_77973_b() instanceof AtlasItem) {
            return this.getAtlasData(AtlasItem.getAtlasID(stack), world);
        }
        return null;
    }

    public AtlasData getAtlasData(int atlasID, World world) {
        AtlasData data;
        String key = this.getAtlasDataKey(atlasID);
        if (world.field_72995_K) {
            data = this.atlasDataClientCache.computeIfAbsent(key, AtlasData::new);
        } else {
            DimensionSavedDataManager manager = ((ServerWorld)world).func_217481_x();
            data = (AtlasData)manager.func_215752_a(() -> new AtlasData(key), key);
        }
        return data;
    }

    private String getAtlasDataKey(int atlasID) {
        return ATLAS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean isRemote) {
        this.atlasDataClientCache.clear();
    }
}

